/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.type.converter;

import java.util.EnumMap;
import org.powerflows.dmn.engine.evaluator.type.converter.BooleanConverter;
import org.powerflows.dmn.engine.evaluator.type.converter.DoubleConverter;
import org.powerflows.dmn.engine.evaluator.type.converter.IntegerConverter;
import org.powerflows.dmn.engine.evaluator.type.converter.StringConverter;
import org.powerflows.dmn.engine.evaluator.type.converter.TypeConverter;
import org.powerflows.dmn.engine.model.decision.field.ValueType;

public class TypeConverterFactory {
    private final EnumMap<ValueType, TypeConverter> factories = new EnumMap(ValueType.class);

    public TypeConverterFactory() {
        this.factories.put(ValueType.STRING, new StringConverter());
        this.factories.put(ValueType.INTEGER, new IntegerConverter());
        this.factories.put(ValueType.DOUBLE, new DoubleConverter());
        this.factories.put(ValueType.BOOLEAN, new BooleanConverter());
    }

    public TypeConverter getInstance(ValueType valueType) {
        TypeConverter typeConverter = this.factories.get((Object)valueType);
        if (typeConverter == null) {
            throw new IllegalArgumentException("Unknown value type");
        }
        return typeConverter;
    }
}

