/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider;

import java.util.EnumMap;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.expression.provider.FeelExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.expression.provider.JuelExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.expression.provider.LiteralExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.expression.provider.ScriptExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.expression.script.ScriptEngineProvider;
import org.powerflows.dmn.engine.model.decision.expression.ExpressionType;

public class EvaluationProviderFactory {
    private final EnumMap<ExpressionType, ExpressionEvaluationProvider> factories = new EnumMap(ExpressionType.class);

    public EvaluationProviderFactory(ScriptEngineProvider scriptEngineProvider) {
        ScriptExpressionEvaluationProvider scriptExpressionEvaluationProvider = new ScriptExpressionEvaluationProvider(scriptEngineProvider);
        this.factories.put(ExpressionType.LITERAL, new LiteralExpressionEvaluationProvider());
        this.factories.put(ExpressionType.FEEL, new FeelExpressionEvaluationProvider());
        this.factories.put(ExpressionType.JUEL, new JuelExpressionEvaluationProvider());
        this.factories.put(ExpressionType.GROOVY, scriptExpressionEvaluationProvider);
        this.factories.put(ExpressionType.JAVASCRIPT, scriptExpressionEvaluationProvider);
    }

    public ExpressionEvaluationProvider getInstance(ExpressionType expressionType) {
        ExpressionEvaluationProvider expressionEvaluationProvider = this.factories.get((Object)expressionType);
        if (expressionEvaluationProvider == null) {
            throw new IllegalArgumentException("Unknown expression type");
        }
        return expressionEvaluationProvider;
    }
}

