/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import lombok.Generated;
import org.powerflows.dmn.engine.evaluator.context.EvaluationContext;
import org.powerflows.dmn.engine.evaluator.exception.EvaluationException;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.expression.script.ScriptEngineProvider;
import org.powerflows.dmn.engine.evaluator.expression.script.bindings.ContextVariablesBindings;
import org.powerflows.dmn.engine.model.decision.expression.Expression;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScriptExpressionEvaluationProvider
implements ExpressionEvaluationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScriptExpressionEvaluationProvider.class);
    private final ScriptEngineProvider scriptEngineProvider;

    public ScriptExpressionEvaluationProvider(ScriptEngineProvider scriptEngineProvider) {
        this.scriptEngineProvider = scriptEngineProvider;
    }

    @Override
    public Object evaluateInput(Input input, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of input: {} with evaluation context: {}", (Object)input, (Object)evaluationContext);
        Object result = this.evaluate(input.getExpression(), evaluationContext);
        log.debug("Evaluated result: {}", result);
        return result;
    }

    @Override
    public Object evaluateEntry(Expression entryExpression, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of entry with expression: {} and evaluation context: {}", (Object)entryExpression, (Object)evaluationContext);
        Object result = this.evaluate(entryExpression, evaluationContext);
        log.debug("Evaluated entry result: {}", result);
        return result;
    }

    private Object evaluate(Expression expression, EvaluationContext evaluationContext) {
        Object result;
        ScriptEngine scriptEngine = this.scriptEngineProvider.getScriptEngine(expression.getType());
        ContextVariablesBindings bindings = ContextVariablesBindings.create(scriptEngine.createBindings(), evaluationContext);
        try {
            result = scriptEngine.eval((String)expression.getValue(), (Bindings)bindings);
        }
        catch (ScriptException e) {
            throw new EvaluationException("Script evaluation exception", e);
        }
        return result;
    }
}

