/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.configuration;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.powerflows.dmn.engine.DecisionEngine;
import org.powerflows.dmn.engine.DefaultDecisionEngine;
import org.powerflows.dmn.engine.configuration.DecisionEngineConfiguration;
import org.powerflows.dmn.engine.evaluator.decision.DecisionEvaluator;
import org.powerflows.dmn.engine.evaluator.entry.InputEntryEvaluator;
import org.powerflows.dmn.engine.evaluator.entry.OutputEntryEvaluator;
import org.powerflows.dmn.engine.evaluator.entry.mode.provider.EvaluationModeProviderFactory;
import org.powerflows.dmn.engine.evaluator.expression.provider.DefaultExpressionEvaluationProviderFactory;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationConfiguration;
import org.powerflows.dmn.engine.evaluator.expression.provider.binding.MethodBinding;
import org.powerflows.dmn.engine.evaluator.rule.RuleEvaluator;
import org.powerflows.dmn.engine.evaluator.type.converter.TypeConverterFactory;

public class DefaultDecisionEngineConfiguration
implements DecisionEngineConfiguration {
    private List<MethodBinding> methodBindings = Collections.emptyList();
    private ExpressionEvaluationConfiguration configuration;
    private DecisionEvaluator decisionEvaluator;
    private RuleEvaluator ruleEvaluator;
    private EvaluationModeProviderFactory evaluationModeProviderFactory;
    private InputEntryEvaluator inputEntryEvaluator;
    private OutputEntryEvaluator outputEntryEvaluator;
    private DefaultExpressionEvaluationProviderFactory expressionEvaluationProviderFactory;
    private TypeConverterFactory typeConverterFactory;

    @Override
    public DecisionEngine configure() {
        this.initExpressionEvaluation();
        this.initEvaluationProviderFactory();
        this.initTypeConverterFactory();
        this.initEvaluationModeProviderFactory();
        this.initInputEntryEvaluator();
        this.initOutputEntryEvaluator();
        this.initRuleEvaluator();
        this.initDecisionEvaluator();
        return new DefaultDecisionEngine(this.decisionEvaluator);
    }

    private void initExpressionEvaluation() {
        this.configuration = ExpressionEvaluationConfiguration.builder().methodBinding(this.methodBindings).build();
    }

    private void initEvaluationProviderFactory() {
        this.expressionEvaluationProviderFactory = new DefaultExpressionEvaluationProviderFactory(this.configuration);
    }

    private void initTypeConverterFactory() {
        this.typeConverterFactory = new TypeConverterFactory();
    }

    private void initEvaluationModeProviderFactory() {
        this.evaluationModeProviderFactory = new EvaluationModeProviderFactory();
    }

    private void initInputEntryEvaluator() {
        this.inputEntryEvaluator = new InputEntryEvaluator(this.expressionEvaluationProviderFactory, this.typeConverterFactory, this.evaluationModeProviderFactory);
    }

    private void initOutputEntryEvaluator() {
        this.outputEntryEvaluator = new OutputEntryEvaluator(this.expressionEvaluationProviderFactory, this.typeConverterFactory);
    }

    private void initRuleEvaluator() {
        this.ruleEvaluator = new RuleEvaluator(this.inputEntryEvaluator, this.outputEntryEvaluator);
    }

    private void initDecisionEvaluator() {
        this.decisionEvaluator = new DecisionEvaluator(this.ruleEvaluator);
    }

    @Generated
    public DefaultDecisionEngineConfiguration methodBindings(List<MethodBinding> methodBindings) {
        this.methodBindings = methodBindings;
        return this;
    }
}

