/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider;

import java.io.Serializable;
import lombok.Generated;
import org.powerflows.dmn.engine.evaluator.context.EvaluationContext;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationProvider;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.rule.entry.InputEntry;
import org.powerflows.dmn.engine.model.decision.rule.entry.OutputEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LiteralExpressionEvaluationProvider
implements ExpressionEvaluationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LiteralExpressionEvaluationProvider.class);

    LiteralExpressionEvaluationProvider() {
    }

    @Override
    public Serializable evaluateInput(Input input, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of input: {} with evaluation context: {}", (Object)input, (Object)evaluationContext);
        Serializable value = evaluationContext.get(input.getName());
        if (value == null) {
            log.warn("Input value by name {} is null", (Object)input.getName());
            value = evaluationContext.get(input.getNameAlias());
            if (value == null) {
                log.warn("Input value by name alias {} is null", (Object)input.getNameAlias());
            } else {
                evaluationContext.addVariable(input.getName(), value);
            }
        }
        log.debug("Evaluated input result: {}", (Object)value);
        return value;
    }

    @Override
    public Serializable evaluateInputEntry(InputEntry inputEntry, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of input entry with evaluation context: {}", (Object)inputEntry, (Object)evaluationContext);
        Serializable result = inputEntry.getExpression().getValue();
        log.debug("Evaluated input entry result: {}", (Object)result);
        return result;
    }

    @Override
    public Serializable evaluateOutputEntry(OutputEntry outputEntry, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of output entry with evaluation context: {}", (Object)outputEntry, (Object)evaluationContext);
        Serializable result = outputEntry.getExpression().getValue();
        log.debug("Evaluated output entry result: {}", (Object)result);
        return result;
    }
}

