/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.type.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.powerflows.dmn.engine.evaluator.exception.EvaluationException;
import org.powerflows.dmn.engine.evaluator.type.converter.TypeConverter;
import org.powerflows.dmn.engine.evaluator.type.value.IntegerValue;
import org.powerflows.dmn.engine.evaluator.type.value.SpecifiedTypeValue;

public class IntegerConverter
implements TypeConverter<Integer> {
    @Override
    public SpecifiedTypeValue<Integer> convert(Object unspecifiedValue) {
        IntegerValue integerTypeValue;
        if (unspecifiedValue instanceof Collection) {
            List<Integer> integerValues = this.convertCollection((Collection)unspecifiedValue);
            integerTypeValue = new IntegerValue(integerValues);
        } else if (unspecifiedValue.getClass().isArray()) {
            List<Integer> integerValues = this.convertArray((Object[])unspecifiedValue);
            integerTypeValue = new IntegerValue(integerValues);
        } else {
            Integer integerValue = this.convertSingleObject(unspecifiedValue);
            integerTypeValue = new IntegerValue(integerValue);
        }
        return integerTypeValue;
    }

    private boolean isInteger(Number value) {
        double doubleValue = value.doubleValue();
        return doubleValue == (double)((int)doubleValue);
    }

    private List<Integer> convertCollection(Collection<Object> unspecifiedValues) {
        return unspecifiedValues.stream().map(this::convertSingleObject).collect(Collectors.toList());
    }

    private List<Integer> convertArray(Object[] unspecifiedValues) {
        return this.convertCollection(new ArrayList<Object>(Arrays.asList(unspecifiedValues)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Integer convertSingleObject(Object unspecifiedValue) {
        int intValue;
        if (unspecifiedValue instanceof Number) {
            if (!this.isInteger((Number)unspecifiedValue)) throw new EvaluationException("Value " + unspecifiedValue + " is not integer");
            intValue = ((Number)unspecifiedValue).intValue();
            return intValue;
        }
        if (!(unspecifiedValue instanceof String)) throw new EvaluationException("Value " + unspecifiedValue + " is not integer");
        try {
            intValue = Integer.parseInt((String)unspecifiedValue);
            return intValue;
        }
        catch (NumberFormatException e) {
            throw new EvaluationException("Value " + unspecifiedValue + " is not integer");
        }
    }
}

