/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.model.decision;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.powerflows.dmn.engine.model.builder.AbstractBuilder;
import org.powerflows.dmn.engine.model.decision.DecisionBuildException;
import org.powerflows.dmn.engine.model.decision.DecisionUtil;
import org.powerflows.dmn.engine.model.decision.EvaluationMode;
import org.powerflows.dmn.engine.model.decision.HitPolicy;
import org.powerflows.dmn.engine.model.decision.expression.ExpressionType;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.field.Output;
import org.powerflows.dmn.engine.model.decision.rule.Rule;
import org.powerflows.dmn.engine.model.decision.rule.entry.InputEntry;
import org.powerflows.dmn.engine.model.decision.rule.entry.OutputEntry;

public class Decision
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final HitPolicy DEFAULT_HIT_POLICY = HitPolicy.UNIQUE;
    public static final ExpressionType DEFAULT_EXPRESSION_TYPE = ExpressionType.LITERAL;
    public static final EvaluationMode DEFAULT_EVALUATION_MODE = EvaluationMode.BOOLEAN;
    private String id;
    private String name;
    private HitPolicy hitPolicy = DEFAULT_HIT_POLICY;
    private ExpressionType expressionType = DEFAULT_EXPRESSION_TYPE;
    private EvaluationMode evaluationMode = DEFAULT_EVALUATION_MODE;
    private List<Input> inputs = new ArrayList<Input>();
    private List<Output> outputs = new ArrayList<Output>();
    private List<Rule> rules = new ArrayList<Rule>();

    private Decision() {
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public HitPolicy getHitPolicy() {
        return this.hitPolicy;
    }

    public ExpressionType getExpressionType() {
        return this.expressionType;
    }

    public EvaluationMode getEvaluationMode() {
        return this.evaluationMode;
    }

    public List<Input> getInputs() {
        return this.inputs;
    }

    public List<Output> getOutputs() {
        return this.outputs;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public static FluentBuilder fluentBuilder() {
        return new FluentBuilder();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Decision)) {
            return false;
        }
        Decision other = (Decision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        HitPolicy this$hitPolicy = this.getHitPolicy();
        HitPolicy other$hitPolicy = other.getHitPolicy();
        if (this$hitPolicy == null ? other$hitPolicy != null : !((Object)((Object)this$hitPolicy)).equals((Object)other$hitPolicy)) {
            return false;
        }
        ExpressionType this$expressionType = this.getExpressionType();
        ExpressionType other$expressionType = other.getExpressionType();
        if (this$expressionType == null ? other$expressionType != null : !((Object)((Object)this$expressionType)).equals((Object)other$expressionType)) {
            return false;
        }
        EvaluationMode this$evaluationMode = this.getEvaluationMode();
        EvaluationMode other$evaluationMode = other.getEvaluationMode();
        if (this$evaluationMode == null ? other$evaluationMode != null : !((Object)((Object)this$evaluationMode)).equals((Object)other$evaluationMode)) {
            return false;
        }
        List<Input> this$inputs = this.getInputs();
        List<Input> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        List<Output> this$outputs = this.getOutputs();
        List<Output> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        List<Rule> this$rules = this.getRules();
        List<Rule> other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Decision;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        HitPolicy $hitPolicy = this.getHitPolicy();
        result = result * 59 + ($hitPolicy == null ? 43 : ((Object)((Object)$hitPolicy)).hashCode());
        ExpressionType $expressionType = this.getExpressionType();
        result = result * 59 + ($expressionType == null ? 43 : ((Object)((Object)$expressionType)).hashCode());
        EvaluationMode $evaluationMode = this.getEvaluationMode();
        result = result * 59 + ($evaluationMode == null ? 43 : ((Object)((Object)$evaluationMode)).hashCode());
        List<Input> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        List<Output> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        List<Rule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Decision(id=" + this.getId() + ", name=" + this.getName() + ", hitPolicy=" + (Object)((Object)this.getHitPolicy()) + ", expressionType=" + (Object)((Object)this.getExpressionType()) + ", evaluationMode=" + (Object)((Object)this.getEvaluationMode()) + ", inputs=" + this.getInputs() + ", outputs=" + this.getOutputs() + ", rules=" + this.getRules() + ")";
    }

    public static final class FluentBuilder
    extends DecisionBuilder<FluentBuilder> {
        private FluentBuilder() {
        }

        public Input.FluentBuilder<FluentBuilder> withInputs() {
            Consumer<Input> inputConsumer = ((Decision)this.product).inputs::add;
            return Input.fluentBuilder(this, inputConsumer);
        }

        public Output.FluentBuilder<FluentBuilder> withOutputs() {
            Consumer<Output> outputConsumer = ((Decision)this.product).outputs::add;
            return Output.fluentBuilder(this, outputConsumer);
        }

        public Rule.FluentBuilder<FluentBuilder> withRules() {
            Consumer<Rule> ruleConsumer = ((Decision)this.product).rules::add;
            return Rule.fluentBuilder(this, ruleConsumer);
        }
    }

    public static final class Builder
    extends DecisionBuilder<Builder> {
        public Builder withInput(Function<Input.Builder, Input> inputsBuilderConsumer) {
            ((Decision)this.product).inputs.add(inputsBuilderConsumer.apply(Input.builder()));
            return this;
        }

        public Builder withOutput(Function<Output.Builder, Output> outputsBuilderConsumer) {
            ((Decision)this.product).outputs.add(outputsBuilderConsumer.apply(Output.builder()));
            return this;
        }

        public Builder withRule(Function<Rule.Builder, Rule> ruleBuilderConsumer) {
            ((Decision)this.product).rules.add(ruleBuilderConsumer.apply(Rule.builder()));
            return this;
        }
    }

    private static abstract class DecisionBuilder<B extends DecisionBuilder<B>>
    extends AbstractBuilder<Decision> {
        private DecisionBuilder() {
        }

        @Override
        protected void initProduct() {
            this.product = new Decision();
        }

        public B id(String id) {
            ((Decision)this.product).id = id;
            return (B)this;
        }

        public B name(String name) {
            ((Decision)this.product).name = name;
            return (B)this;
        }

        public B hitPolicy(HitPolicy hitPolicy) {
            ((Decision)this.product).hitPolicy = hitPolicy;
            return (B)this;
        }

        public B expressionType(ExpressionType expressionType) {
            ((Decision)this.product).expressionType = expressionType;
            return (B)this;
        }

        public B evaluationMode(EvaluationMode evaluationMode) {
            ((Decision)this.product).evaluationMode = evaluationMode;
            return (B)this;
        }

        @Override
        protected Decision assembleProduct() {
            this.validateIsNonEmpty(((Decision)this.product).inputs, "At least one input is required");
            this.validateIsNonEmpty(((Decision)this.product).outputs, "At least one output is required");
            this.validateIsNonEmpty(((Decision)this.product).rules, "At least one rule is required");
            List<String> inputNames = ((Decision)this.product).inputs.stream().map(Input::getName).collect(Collectors.toList());
            List<String> outputNames = ((Decision)this.product).outputs.stream().map(Output::getName).collect(Collectors.toList());
            this.validateIsNonDuplicated(inputNames, "Inputs must have unique names. Duplicated names: ");
            this.validateIsNonDuplicated(outputNames, "Outputs must have unique names. Duplicated names: ");
            ((Decision)this.product).rules.forEach(rule -> {
                List<String> inputEntryNames = rule.getInputEntries().stream().map(InputEntry::getName).collect(Collectors.toList());
                this.validateIsNonDuplicated(inputEntryNames, "Input entries must have unique names. Duplicated names: ");
                this.validateAreEntriesMatch(inputNames, inputEntryNames, "Input entries refer to non existing inputs: ");
                List<String> outputEntryNames = rule.getOutputEntries().stream().map(OutputEntry::getName).collect(Collectors.toList());
                this.validateIsNonDuplicated(outputEntryNames, "Output entries must have unique names. Duplicated names: ");
                this.validateAreEntriesMatch(outputNames, outputEntryNames, "Output entries refer to non existing outputs: ");
            });
            this.validateIsNonNull((Serializable)((Object)((Decision)this.product).id), "Id is required");
            this.validateIsNonNull((Serializable)((Object)((Decision)this.product).name), "Name is required");
            this.validateIsNonNull((Serializable)((Object)((Decision)this.product).hitPolicy), "Hit policy is required");
            this.validateIsNonNull((Serializable)((Object)((Decision)this.product).expressionType), "Expression type is required");
            this.validateIsNonNull((Serializable)((Object)((Decision)this.product).evaluationMode), "Evaluation mode is required");
            DecisionUtil.assignDefaults(((Decision)this.product).inputs, ((Decision)this.product).rules, ((Decision)this.product).expressionType, ((Decision)this.product).evaluationMode);
            ((Decision)this.product).inputs = Collections.unmodifiableList(((Decision)this.product).inputs);
            ((Decision)this.product).outputs = Collections.unmodifiableList(((Decision)this.product).outputs);
            ((Decision)this.product).rules = Collections.unmodifiableList(((Decision)this.product).rules);
            return (Decision)this.product;
        }

        private void validateAreEntriesMatch(List<String> fields, List<String> entries, String message) {
            List missing = entries.stream().filter(s -> !fields.contains(s)).collect(Collectors.toList());
            if (!missing.isEmpty()) {
                throw new DecisionBuildException(message + missing);
            }
        }

        private void validateIsNonDuplicated(List<String> names, String message) {
            Set duplicates = names.stream().collect(Collectors.collectingAndThen(Collectors.groupingBy(Function.identity(), Collectors.counting()), map -> {
                map.values().removeIf(count -> count == 1L);
                return map.keySet();
            }));
            if (!duplicates.isEmpty()) {
                throw new DecisionBuildException(message + duplicates);
            }
        }
    }
}

