/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.model.evaluation.result;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.powerflows.dmn.engine.model.builder.AbstractBuilder;
import org.powerflows.dmn.engine.model.evaluation.result.EntryResult;
import org.powerflows.dmn.engine.model.evaluation.result.RuleResult;
import org.powerflows.dmn.engine.model.evaluation.result.exception.EvaluationResultException;

public class DecisionResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int SINGLE_ITEM_COLLECTION_SIZE = 1;
    private static final int FIRST_ITEM_COLLECTION_INDEX = 0;
    private List<RuleResult> ruleResults = new ArrayList<RuleResult>();

    private DecisionResult() {
    }

    public boolean isSingleEntryResult() {
        return this.isSingleRuleResult() && this.getSingleRuleResult().getEntryResults().size() == 1;
    }

    public boolean isSingleRuleResult() {
        return this.ruleResults.size() == 1;
    }

    public boolean isCollectionRulesResult() {
        return !this.isSingleRuleResult();
    }

    public EntryResult getSingleEntryResult() {
        if (!this.isSingleEntryResult()) {
            throw new EvaluationResultException("Evaluation has no single entry result");
        }
        return this.getSingleRuleResult().getEntryResults().get(0);
    }

    public RuleResult getSingleRuleResult() {
        if (!this.isSingleRuleResult()) {
            throw new EvaluationResultException("Evaluation has no single result");
        }
        return this.ruleResults.get(0);
    }

    public List<RuleResult> getCollectionRulesResult() {
        return this.ruleResults;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String toString() {
        return "DecisionResult(ruleResults=" + this.ruleResults + ")";
    }

    public static final class Builder
    extends AbstractBuilder<DecisionResult> {
        private Builder() {
        }

        @Override
        protected void initProduct() {
            this.product = new DecisionResult();
        }

        public Builder ruleResults(List<RuleResult> ruleResults) {
            ((DecisionResult)this.product).ruleResults = ruleResults;
            return this;
        }

        @Override
        protected DecisionResult assembleProduct() {
            ((DecisionResult)this.product).ruleResults = Collections.unmodifiableList(((DecisionResult)this.product).ruleResults);
            return (DecisionResult)this.product;
        }
    }
}

