/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.io.yaml;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.powerflows.dmn.engine.model.decision.Decision;
import org.powerflows.dmn.engine.model.decision.EvaluationMode;
import org.powerflows.dmn.engine.model.decision.HitPolicy;
import org.powerflows.dmn.engine.model.decision.expression.Expression;
import org.powerflows.dmn.engine.model.decision.expression.ExpressionType;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.field.Output;
import org.powerflows.dmn.engine.model.decision.rule.Rule;
import org.powerflows.dmn.engine.model.decision.rule.entry.InputEntry;
import org.powerflows.dmn.engine.model.decision.rule.entry.OutputEntry;
import org.powerflows.dmn.io.DecisionToExternalModelConverter;
import org.powerflows.dmn.io.yaml.model.YamlDecision;
import org.powerflows.dmn.io.yaml.model.field.YamlFields;
import org.powerflows.dmn.io.yaml.model.field.YamlInput;
import org.powerflows.dmn.io.yaml.model.field.YamlOutput;
import org.powerflows.dmn.io.yaml.model.rule.YamlRule;
import org.powerflows.dmn.io.yaml.model.rule.entry.YamlInputEntry;
import org.powerflows.dmn.io.yaml.model.rule.entry.YamlOutputEntry;

public class YamlDecisionConverter
implements DecisionToExternalModelConverter<YamlDecision> {
    @Override
    public YamlDecision to(Decision decision) {
        ExpressionType decisionExpressionType = this.findDecisionExpressionType(decision);
        EvaluationMode decisionEvaluationMode = Decision.DEFAULT_EVALUATION_MODE.equals((Object)decision.getEvaluationMode()) ? null : decision.getEvaluationMode();
        HitPolicy decisionHitPolicy = Decision.DEFAULT_HIT_POLICY.equals((Object)decision.getHitPolicy()) ? null : decision.getHitPolicy();
        YamlDecision yamlDecision = new YamlDecision();
        yamlDecision.setId(decision.getId());
        yamlDecision.setName(decision.getName());
        yamlDecision.setExpressionType(Decision.DEFAULT_EXPRESSION_TYPE.equals((Object)decisionExpressionType) ? null : decisionExpressionType);
        yamlDecision.setEvaluationMode(decisionEvaluationMode);
        yamlDecision.setHitPolicy(decisionHitPolicy);
        yamlDecision.setFields(this.createFields(decision.getInputs(), decision.getOutputs(), decisionEvaluationMode, decisionExpressionType));
        Map inputsMap = decision.getInputs().stream().collect(Collectors.toMap(Input::getName, Function.identity()));
        yamlDecision.setRules(decision.getRules().stream().map(rule -> this.ruleToYamlRule((Rule)rule, inputsMap, decisionExpressionType)).collect(Collectors.toList()));
        return yamlDecision;
    }

    private ExpressionType findDecisionExpressionType(Decision decision) {
        ExpressionType expressionType = decision.getRules().get(0).getInputEntries().get(0).getExpression().getType();
        for (Rule rule : decision.getRules()) {
            for (InputEntry inputEntry : rule.getInputEntries()) {
                if (expressionType.equals((Object)inputEntry.getExpression().getType())) continue;
                return decision.getExpressionType();
            }
            for (OutputEntry outputEntry : rule.getOutputEntries()) {
                if (expressionType.equals((Object)outputEntry.getExpression().getType())) continue;
                return decision.getExpressionType();
            }
        }
        return expressionType;
    }

    private YamlFields createFields(List<Input> inputs, List<Output> outputs, EvaluationMode decisionEvaluationMode, ExpressionType decisionExpressionType) {
        YamlFields yamlFields = new YamlFields();
        LinkedHashMap<String, YamlInput> in = new LinkedHashMap<String, YamlInput>();
        yamlFields.setIn(in);
        LinkedHashMap<String, YamlOutput> out = new LinkedHashMap<String, YamlOutput>();
        yamlFields.setOut(out);
        inputs.forEach(input -> {
            YamlInput yamlInput = new YamlInput();
            yamlInput.setDescription(input.getDescription());
            yamlInput.setType(input.getType());
            if (decisionEvaluationMode != null && !decisionEvaluationMode.equals((Object)input.getEvaluationMode())) {
                yamlInput.setEvaluationMode(input.getEvaluationMode());
            }
            if (!"cellInput".equals(input.getNameAlias())) {
                yamlInput.setNameAlias(input.getNameAlias());
            }
            yamlInput.setExpression(input.getExpression().getValue());
            if (!decisionExpressionType.equals((Object)input.getExpression().getType())) {
                yamlInput.setExpressionType(input.getExpression().getType());
            }
            in.put(input.getName(), yamlInput);
        });
        outputs.forEach(output -> {
            YamlOutput yamlOutput = new YamlOutput();
            yamlOutput.setDescription(output.getDescription());
            yamlOutput.setType(output.getType());
            out.put(output.getName(), yamlOutput);
        });
        return yamlFields;
    }

    private YamlRule ruleToYamlRule(Rule rule, Map<String, Input> inputsMap, ExpressionType decisionExpressionType) {
        YamlRule yamlRule = new YamlRule();
        yamlRule.setDescription(rule.getDescription());
        LinkedHashMap<String, YamlInputEntry> in = new LinkedHashMap<String, YamlInputEntry>();
        yamlRule.setIn(in);
        LinkedHashMap<String, YamlOutputEntry> out = new LinkedHashMap<String, YamlOutputEntry>();
        yamlRule.setOut(out);
        rule.getInputEntries().forEach(inputEntry -> {
            Input input = (Input)inputsMap.get(inputEntry.getName());
            YamlInputEntry yamlInputEntry = new YamlInputEntry();
            yamlInputEntry.setExpression(inputEntry.getExpression().getValue());
            if (!inputEntry.getExpression().getType().equals((Object)decisionExpressionType)) {
                yamlInputEntry.setExpressionType(inputEntry.getExpression().getType());
            }
            if (!input.getEvaluationMode().equals((Object)inputEntry.getEvaluationMode())) {
                yamlInputEntry.setEvaluationMode(inputEntry.getEvaluationMode());
            }
            if (!inputEntry.getNameAlias().equals(input.getNameAlias())) {
                yamlInputEntry.setNameAlias(inputEntry.getNameAlias());
            }
            in.put(inputEntry.getName(), yamlInputEntry);
        });
        rule.getOutputEntries().forEach(outputEntry -> {
            YamlOutputEntry yamlOutputEntry = new YamlOutputEntry();
            if (!outputEntry.getExpression().getType().equals((Object)decisionExpressionType)) {
                yamlOutputEntry.setExpressionType(outputEntry.getExpression().getType());
            }
            yamlOutputEntry.setExpression(outputEntry.getExpression().getValue());
            out.put(outputEntry.getName(), yamlOutputEntry);
        });
        return yamlRule;
    }

    @Override
    public Decision from(YamlDecision model) {
        Decision.Builder builder = Decision.builder();
        ((Decision.Builder)builder.id(model.getId())).name(model.getName());
        if (model.getExpressionType() != null) {
            builder.expressionType(model.getExpressionType());
        }
        if (model.getEvaluationMode() != null) {
            builder.evaluationMode(model.getEvaluationMode());
        }
        if (model.getHitPolicy() != null) {
            builder.hitPolicy(model.getHitPolicy());
        }
        model.getFields().getIn().forEach((name, input) -> builder.withInput(inputBuilder -> {
            if (input.getNameAlias() != null) {
                inputBuilder.nameAlias(input.getNameAlias());
            }
            return (Input)((Input.Builder)((Input.Builder)((Input.Builder)((Input.Builder)inputBuilder.name((String)name)).type(input.getType())).evaluationMode(input.getEvaluationMode())).description(input.getDescription())).withExpression(expressionBuilder -> (Expression)((Expression.Builder)((Expression.Builder)expressionBuilder.type(input.getExpressionType())).value((Serializable)input.getExpression())).build()).build();
        }));
        model.getFields().getOut().forEach((name, output) -> builder.withOutput(outpBuilder -> (Output)((Output.Builder)((Output.Builder)((Output.Builder)outpBuilder.name((String)name)).type(output.getType())).description(output.getDescription())).build()));
        model.getRules().forEach(rule -> builder.withRule(ruleBuilder -> {
            rule.getIn().forEach((name, inputEntry) -> ruleBuilder.withInputEntry(inputEntryBuilder -> (InputEntry)((InputEntry.Builder)((InputEntry.Builder)((InputEntry.Builder)inputEntryBuilder.name((String)name)).nameAlias(inputEntry.getNameAlias())).evaluationMode(inputEntry.getEvaluationMode())).withExpression(expressionBuilder -> (Expression)((Expression.Builder)((Expression.Builder)expressionBuilder.type(inputEntry.getExpressionType())).value((Serializable)inputEntry.getExpression())).build()).build()));
            rule.getOut().forEach((name, outputEntry) -> ruleBuilder.withOutputEntry(outputEntryBuilder -> (OutputEntry)((OutputEntry.Builder)outputEntryBuilder.name((String)name)).withExpression(expressionBuilder -> (Expression)((Expression.Builder)((Expression.Builder)expressionBuilder.type(outputEntry.getExpressionType())).value((Serializable)outputEntry.getExpression())).build()).build()));
            return (Rule)((Rule.Builder)ruleBuilder.description(rule.getDescription())).build();
        }));
        return (Decision)builder.build();
    }
}

