/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider;

import java.util.EnumMap;
import java.util.Optional;
import java.util.ServiceLoader;
import lombok.Generated;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationConfiguration;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationProviderFactory;
import org.powerflows.dmn.engine.model.decision.expression.ExpressionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExpressionEvaluationProviderFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultExpressionEvaluationProviderFactory.class);
    private static final ServiceLoader<ExpressionEvaluationProviderFactory> serviceLoader = ServiceLoader.load(ExpressionEvaluationProviderFactory.class);
    private final EnumMap<ExpressionType, ExpressionEvaluationProviderFactory> factories = new EnumMap(ExpressionType.class);
    private final EnumMap<ExpressionType, ExpressionEvaluationProvider> providers = new EnumMap(ExpressionType.class);
    private final ExpressionEvaluationConfiguration configuration;

    public DefaultExpressionEvaluationProviderFactory() {
        this(ExpressionEvaluationConfiguration.simpleConfiguration());
    }

    public DefaultExpressionEvaluationProviderFactory(ExpressionEvaluationConfiguration configuration) {
        this.configuration = configuration;
        serviceLoader.forEach(provider -> provider.supportedExpressionTypes().forEach(type -> {
            log.debug("Found ExpressionEvaluationProvider for type {} - {}", (Object)type, provider);
            this.factories.put((ExpressionType)((Object)((Object)type)), (ExpressionEvaluationProviderFactory)provider);
        }));
    }

    public ExpressionEvaluationProvider getInstance(ExpressionType expressionType) {
        ExpressionEvaluationProvider expressionEvaluationProvider = this.providers.computeIfAbsent(expressionType, key -> Optional.ofNullable(this.factories.get(key)).map(factory -> factory.createProvider(this.configuration)).orElse(null));
        if (expressionEvaluationProvider == null) {
            throw new IllegalArgumentException("Unknown expression type " + (Object)((Object)expressionType));
        }
        return expressionEvaluationProvider;
    }
}

