/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.type.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.powerflows.dmn.engine.evaluator.exception.EvaluationException;
import org.powerflows.dmn.engine.evaluator.type.converter.TypeConverter;
import org.powerflows.dmn.engine.evaluator.type.value.DateValue;
import org.powerflows.dmn.engine.evaluator.type.value.SpecifiedTypeValue;

public class DateConverter
implements TypeConverter<Date> {
    private final Pattern dateRegexp = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)$");
    private final Pattern dateTimeRegexp = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:(?:[Tt]|[ \t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \t]*(?:Z|([-+][0-9][0-9]?)(?::([0-9][0-9])?)?))?)?$");

    @Override
    public SpecifiedTypeValue<Date> convert(Object unspecifiedValue) {
        DateValue dateTypeValue;
        if (unspecifiedValue == null) {
            Date dateValue = null;
            dateTypeValue = new DateValue(dateValue);
        } else if (unspecifiedValue instanceof Collection) {
            List<Date> dateValues = this.convertCollection((Collection)unspecifiedValue);
            dateTypeValue = new DateValue(dateValues);
        } else if (unspecifiedValue.getClass().isArray()) {
            List<Date> dateValues = this.convertArray((Object[])unspecifiedValue);
            dateTypeValue = new DateValue(dateValues);
        } else {
            Date dateValue = this.convertSingleObject(unspecifiedValue);
            dateTypeValue = new DateValue(dateValue);
        }
        return dateTypeValue;
    }

    private List<Date> convertCollection(Collection<Object> unspecifiedValues) {
        return unspecifiedValues.stream().map(this::convertSingleObject).collect(Collectors.toList());
    }

    private List<Date> convertArray(Object[] unspecifiedValues) {
        return this.convertCollection(new ArrayList<Object>(Arrays.asList(unspecifiedValues)));
    }

    private Date convertSingleObject(Object unspecifiedValue) {
        Date dateValue;
        if (unspecifiedValue instanceof Date) {
            dateValue = (Date)unspecifiedValue;
        } else if (unspecifiedValue instanceof String) {
            String stringDate = (String)unspecifiedValue;
            Matcher match = this.dateRegexp.matcher(stringDate);
            if (match.matches()) {
                dateValue = this.buildDate(match);
            } else {
                match = this.dateTimeRegexp.matcher(stringDate);
                if (!match.matches()) {
                    throw new EvaluationException("Value " + unspecifiedValue + " is not date");
                }
                dateValue = this.buildDateTime(match);
            }
        } else {
            throw new EvaluationException("Value " + unspecifiedValue + " is not date");
        }
        return dateValue;
    }

    private Date buildDate(Matcher match) {
        String year = match.group(1);
        String month = match.group(2);
        String day = match.group(3);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        calendar.set(1, Integer.parseInt(year));
        calendar.set(2, Integer.parseInt(month) - 1);
        calendar.set(5, Integer.parseInt(day));
        return calendar.getTime();
    }

    private Date buildDateTime(Matcher match) {
        TimeZone timeZone;
        String year = match.group(1);
        String month = match.group(2);
        String day = match.group(3);
        String hour = match.group(4);
        String min = match.group(5);
        String millisecond = match.group(7);
        String secondTmp = match.group(6);
        String second = millisecond != null ? secondTmp + "." + millisecond : secondTmp;
        double doubleSecond = Double.parseDouble(second);
        int intSecond = (int)Math.round(Math.floor(doubleSecond));
        int intMillisecond = (int)Math.round((doubleSecond - (double)intSecond) * 1000.0);
        String timezoneHour = match.group(8);
        String timezoneMinute = match.group(9);
        if (timezoneHour != null) {
            String time = timezoneMinute != null ? ":" + timezoneMinute : "00";
            timeZone = TimeZone.getTimeZone("GMT" + timezoneHour + time);
        } else {
            timeZone = TimeZone.getTimeZone("UTC");
        }
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.set(1, Integer.parseInt(year));
        calendar.set(2, Integer.parseInt(month) - 1);
        calendar.set(5, Integer.parseInt(day));
        calendar.set(11, Integer.parseInt(hour));
        calendar.set(12, Integer.parseInt(min));
        calendar.set(13, intSecond);
        calendar.set(14, intMillisecond);
        return calendar.getTime();
    }
}

