/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.model.decision;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.powerflows.dmn.engine.model.decision.DecisionBuildException;
import org.powerflows.dmn.engine.model.decision.EvaluationMode;
import org.powerflows.dmn.engine.model.decision.expression.Expression;
import org.powerflows.dmn.engine.model.decision.expression.ExpressionType;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.rule.Rule;
import org.powerflows.dmn.engine.model.decision.rule.entry.InputEntry;
import org.powerflows.dmn.engine.model.decision.rule.entry.OutputEntry;

class DecisionUtil {
    private DecisionUtil() {
    }

    static void assignDefaults(List<Input> inputs, List<Rule> rules, ExpressionType decisionExpressionType, EvaluationMode decisionEvaluationMode) {
        Field expressionTypeField = DecisionUtil.findField(Expression.class, "type");
        expressionTypeField.setAccessible(true);
        DecisionUtil.assignInputsDefaults(inputs, decisionExpressionType, decisionEvaluationMode, expressionTypeField);
        DecisionUtil.assignEntriesDefaults(inputs, rules, decisionExpressionType, expressionTypeField);
        expressionTypeField.setAccessible(false);
    }

    private static void assignInputsDefaults(List<Input> inputs, ExpressionType decisionExpressionType, EvaluationMode decisionEvaluationMode, Field expressionTypeField) {
        Field inputEvaluationModeField = DecisionUtil.findField(Input.class, "evaluationMode");
        inputEvaluationModeField.setAccessible(true);
        for (Input input : inputs) {
            if (input.getExpression().getType() == null) {
                DecisionUtil.setValue(expressionTypeField, input.getExpression(), (Object)decisionExpressionType);
            }
            if (input.getEvaluationMode() != null) continue;
            DecisionUtil.setValue(inputEvaluationModeField, input, (Object)decisionEvaluationMode);
        }
        inputEvaluationModeField.setAccessible(false);
    }

    private static void assignEntriesDefaults(List<Input> inputs, List<Rule> rules, ExpressionType decisionExpressionType, Field expressionTypeField) {
        Field inputEntryEvaluationModeField = DecisionUtil.findField(InputEntry.class, "evaluationMode");
        Field inputEntryNameAliasField = DecisionUtil.findField(InputEntry.class, "nameAlias");
        inputEntryEvaluationModeField.setAccessible(true);
        inputEntryNameAliasField.setAccessible(true);
        Map inputsMap = inputs.stream().collect(Collectors.toMap(Input::getName, Function.identity()));
        for (Rule rule : rules) {
            for (InputEntry inputEntry : rule.getInputEntries()) {
                if (inputEntry.getExpression().getType() == null) {
                    DecisionUtil.setValue(expressionTypeField, inputEntry.getExpression(), (Object)decisionExpressionType);
                }
                if (inputEntry.getEvaluationMode() == null) {
                    DecisionUtil.setValue(inputEntryEvaluationModeField, inputEntry, (Object)((Input)inputsMap.get(inputEntry.getName())).getEvaluationMode());
                }
                if (inputEntry.getNameAlias() != null) continue;
                DecisionUtil.setValue(inputEntryNameAliasField, inputEntry, ((Input)inputsMap.get(inputEntry.getName())).getNameAlias());
            }
            for (OutputEntry outputEntry : rule.getOutputEntries()) {
                if (outputEntry.getExpression().getType() != null) continue;
                DecisionUtil.setValue(expressionTypeField, outputEntry.getExpression(), (Object)decisionExpressionType);
            }
        }
        inputEntryEvaluationModeField.setAccessible(false);
        inputEntryNameAliasField.setAccessible(false);
    }

    private static Field findField(Class clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new DecisionBuildException("Can not find " + fieldName + " in " + clazz);
        }
    }

    private static void setValue(Field field, Object object, Object value) {
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new DecisionBuildException("Can not set value " + value + " for " + object, e);
        }
    }
}

