/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.io.yaml;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertySubstitute;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public class CustomPropertyUtils
extends PropertyUtils {
    private Map<Class<?>, Map<String, Property>> propertiesCache = new HashMap();
    private static final Map<String, String> PROPERTY_NAME_MAP = new HashMap<String, String>();

    CustomPropertyUtils() {
        this.setBeanAccess(BeanAccess.FIELD);
    }

    protected Set<Property> createPropertySet(Class<?> type, BeanAccess beanAccess) {
        LinkedHashSet<Property> properties = new LinkedHashSet<Property>();
        for (Property property : this.getPropertiesMap(type, beanAccess).values()) {
            if (!property.isReadable() || !this.isAllowReadOnlyProperties() && !property.isWritable()) continue;
            properties.add(property);
        }
        return properties;
    }

    protected Map<String, Property> getPropertiesMap(Class<?> type, BeanAccess beanAccess) {
        if (this.propertiesCache.containsKey(type)) {
            return this.propertiesCache.get(type);
        }
        LinkedHashMap<String, Property> properties = new LinkedHashMap<String, Property>();
        super.getPropertiesMap(type, beanAccess).forEach((name, property) -> {
            if (PROPERTY_NAME_MAP.containsKey(name)) {
                String newName = PROPERTY_NAME_MAP.get(name);
                PropertySubstitute substitute = new PropertySubstitute(newName, property.getType(), new Class[0]);
                substitute.setDelegate(property);
                properties.put(newName, (Property)substitute);
            } else {
                properties.put((String)name, (Property)property);
            }
        });
        this.propertiesCache.put(type, properties);
        return properties;
    }

    static {
        PROPERTY_NAME_MAP.put("hitPolicy", "hit-policy");
        PROPERTY_NAME_MAP.put("expressionType", "expression-type");
        PROPERTY_NAME_MAP.put("evaluationMode", "evaluation-mode");
        PROPERTY_NAME_MAP.put("nameAlias", "name-alias");
    }
}

