/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.decision;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.powerflows.dmn.engine.evaluator.context.EvaluationContext;
import org.powerflows.dmn.engine.evaluator.exception.EvaluationException;
import org.powerflows.dmn.engine.evaluator.rule.RuleEvaluator;
import org.powerflows.dmn.engine.model.decision.Decision;
import org.powerflows.dmn.engine.model.decision.HitPolicy;
import org.powerflows.dmn.engine.model.decision.expression.Expression;
import org.powerflows.dmn.engine.model.decision.expression.ExpressionType;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.field.Output;
import org.powerflows.dmn.engine.model.decision.rule.Rule;
import org.powerflows.dmn.engine.model.evaluation.result.DecisionResult;
import org.powerflows.dmn.engine.model.evaluation.result.RuleResult;
import org.powerflows.dmn.engine.model.evaluation.variable.DecisionVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionEvaluator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DecisionEvaluator.class);
    private static final Set<HitPolicy> UNSUPPORTED_HIT_POLICIES = Collections.unmodifiableSet(EnumSet.of(HitPolicy.OUTPUT_ORDER, HitPolicy.RULE_ORDER, HitPolicy.PRIORITY));
    private final RuleEvaluator ruleEvaluator;

    public DecisionEvaluator(RuleEvaluator ruleEvaluator) {
        this.ruleEvaluator = ruleEvaluator;
    }

    public DecisionResult evaluate(Decision decision, DecisionVariables decisionVariables) {
        if (decision == null) {
            throw new NullPointerException("Decision can not be null");
        }
        if (decisionVariables == null) {
            throw new NullPointerException("Decision variables can not be null");
        }
        if (this.isUnsupportedSupportedHitPolicy(decision.getHitPolicy())) {
            throw new UnsupportedOperationException("HitPolicy " + (Object)((Object)decision.getHitPolicy()) + " is not supported");
        }
        log.info("Starting evaluation of decision: {} with decision variables: {}", (Object)decision, (Object)decisionVariables);
        this.validateDecisionVariables(decision.getInputs(), decisionVariables);
        ArrayList<RuleResult> ruleResults = new ArrayList<RuleResult>();
        boolean singleNonUniqueRuleResultExpected = this.isSingleNonUniqueRuleResultExpected(decision);
        Map<String, Input> inputs = decision.getInputs().stream().collect(Collectors.toMap(Input::getName, Function.identity()));
        Map<String, Output> outputs = decision.getOutputs().stream().collect(Collectors.toMap(Output::getName, Function.identity()));
        EvaluationContext evaluationContext = new EvaluationContext(decisionVariables);
        for (Rule rule : decision.getRules()) {
            RuleResult ruleResult = this.ruleEvaluator.evaluate(rule, inputs, outputs, evaluationContext);
            if (ruleResult == null) continue;
            ruleResults.add(ruleResult);
            if (!singleNonUniqueRuleResultExpected) continue;
            break;
        }
        if (this.isUniqueRuleResultExpected(decision) && this.isNonUniqueRuleResult(ruleResults)) {
            throw new EvaluationException("Unique result is expected");
        }
        DecisionResult decisionResult = (DecisionResult)DecisionResult.builder().ruleResults(ruleResults).build();
        log.info("Evaluated decision result: {}", (Object)decisionResult);
        return decisionResult;
    }

    private boolean isUnsupportedSupportedHitPolicy(HitPolicy hitPolicy) {
        return UNSUPPORTED_HIT_POLICIES.contains((Object)hitPolicy);
    }

    private void validateDecisionVariables(List<Input> inputs, DecisionVariables decisionVariables) {
        String invalidInputNames = inputs.stream().filter(input -> !this.isLiteral(input.getExpression())).filter(input -> decisionVariables.isPresent(input.getName())).map(Input::getName).collect(Collectors.joining(","));
        if (!invalidInputNames.isEmpty()) {
            throw new EvaluationException("Can not apply decision variables to inputs '" + invalidInputNames + "'. Only to inputs with literal expression possible.");
        }
    }

    private boolean isLiteral(Expression expression) {
        return ExpressionType.LITERAL.equals((Object)expression.getType()) || ExpressionType.FEEL.equals((Object)expression.getType());
    }

    private boolean isSingleNonUniqueRuleResultExpected(Decision decision) {
        return HitPolicy.FIRST.equals((Object)decision.getHitPolicy()) || HitPolicy.ANY.equals((Object)decision.getHitPolicy());
    }

    private boolean isUniqueRuleResultExpected(Decision decision) {
        return HitPolicy.UNIQUE.equals((Object)decision.getHitPolicy());
    }

    private boolean isNonUniqueRuleResult(List<RuleResult> ruleResults) {
        return ruleResults.size() > 1;
    }
}

