/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider;

import java.io.Serializable;
import lombok.Generated;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.powerflows.dmn.engine.evaluator.context.EvaluationContext;
import org.powerflows.dmn.engine.evaluator.exception.EvaluationException;
import org.powerflows.dmn.engine.evaluator.expression.ExpressionEvaluationException;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationConfiguration;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.expression.provider.binding.InstanceMethodBinding;
import org.powerflows.dmn.engine.evaluator.expression.provider.binding.MethodBinding;
import org.powerflows.dmn.engine.model.decision.expression.Expression;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.rule.entry.InputEntry;
import org.powerflows.dmn.engine.model.decision.rule.entry.OutputEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MvelExpressionEvaluationProvider
implements ExpressionEvaluationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MvelExpressionEvaluationProvider.class);
    private final VariableResolverFactory functionResolverFactory = new MapVariableResolverFactory();

    MvelExpressionEvaluationProvider(ExpressionEvaluationConfiguration configuration) {
        configuration.getMethodBindings().forEach(methodBinding -> this.functionResolverFactory.createVariable(methodBinding.name().replaceAll("\\s", ""), this.createMethodBinding((MethodBinding)methodBinding)));
    }

    private Object createMethodBinding(MethodBinding methodBinding) {
        if (methodBinding instanceof InstanceMethodBinding) {
            throw new EvaluationException("Instance method binding for MVEL is not supported yet");
        }
        return methodBinding.method();
    }

    @Override
    public Serializable evaluateInput(Input input, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of input: {} with evaluation context: {}", (Object)input, (Object)evaluationContext);
        Serializable result = this.evaluate(input.getExpression(), evaluationContext);
        log.debug("Evaluated result: {}", (Object)result);
        return result;
    }

    @Override
    public Serializable evaluateInputEntry(InputEntry inputEntry, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of input entry {} with evaluation context: {}", (Object)inputEntry, (Object)evaluationContext);
        Serializable result = this.evaluate(inputEntry, evaluationContext);
        log.debug("Evaluated entry result: {}", (Object)result);
        return result;
    }

    @Override
    public Serializable evaluateOutputEntry(OutputEntry outputEntry, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of output entry {} with evaluation context: {}", (Object)outputEntry, (Object)evaluationContext);
        Serializable result = this.evaluate(outputEntry.getExpression(), evaluationContext);
        log.debug("Evaluated entry result: {}", (Object)result);
        return result;
    }

    Serializable evaluate(InputEntry inputEntry, EvaluationContext evaluationContext) {
        MapVariableResolverFactory mapVariableResolverFactory = new MapVariableResolverFactory();
        this.fillVariables(evaluationContext, (VariableResolverFactory)mapVariableResolverFactory);
        mapVariableResolverFactory.createVariable(inputEntry.getNameAlias(), (Object)evaluationContext.get(inputEntry.getName()));
        return this.evaluate(inputEntry.getExpression(), (VariableResolverFactory)mapVariableResolverFactory);
    }

    final Serializable evaluate(Expression expression, EvaluationContext evaluationContext) {
        MapVariableResolverFactory mapVariableResolverFactory = new MapVariableResolverFactory();
        this.fillVariables(evaluationContext, (VariableResolverFactory)mapVariableResolverFactory);
        return this.evaluate(expression, (VariableResolverFactory)mapVariableResolverFactory);
    }

    final void fillVariables(EvaluationContext evaluationContext, VariableResolverFactory mapVariableResolverFactory) {
        evaluationContext.getAll().keySet().forEach(variableName -> mapVariableResolverFactory.createVariable(variableName, (Object)evaluationContext.get((String)variableName)));
    }

    final Serializable evaluate(Expression expression, VariableResolverFactory variableResolverFactory) {
        Serializable result;
        variableResolverFactory.setNextFactory(this.functionResolverFactory);
        try {
            result = (Serializable)MVEL.eval((String)((String)((Object)expression.getValue())), (VariableResolverFactory)variableResolverFactory);
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException("Can not evaluate feel expression '" + expression.getValue() + "'", e);
        }
        return result;
    }
}

