/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider.feel.converter.mvel;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.powerflows.dmn.engine.evaluator.expression.ExpressionEvaluationException;
import org.powerflows.dmn.engine.evaluator.expression.provider.feel.converter.ExpressionConverter;

public class FeelToMvelComparisonExpressionConverter
implements ExpressionConverter {
    private final Pattern comparisonPattern = Pattern.compile("^(<|<=|>|>=)([^=].*)$");

    @Override
    public String convert(String feelExpression, String inputName) {
        if (inputName == null) {
            throw new ExpressionEvaluationException("Can not evaluate feel expression '" + feelExpression + "', due to applicable only for input entry expressions");
        }
        Matcher matcher = this.comparisonPattern.matcher(feelExpression);
        if (!matcher.matches()) {
            throw new ExpressionEvaluationException("Can not evaluate feel expression '" + feelExpression + "'");
        }
        String operator = matcher.group(1);
        String rightOperand = matcher.group(2);
        return inputName + operator + rightOperand;
    }

    @Override
    public boolean isConvertible(String feelExpression) {
        return feelExpression.startsWith("<") || feelExpression.startsWith("<=") || feelExpression.startsWith(">") || feelExpression.startsWith(">=");
    }
}

