/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.type.converter;

import java.util.List;
import org.powerflows.dmn.engine.evaluator.exception.EvaluationException;
import org.powerflows.dmn.engine.evaluator.type.converter.BaseTypeConverter;
import org.powerflows.dmn.engine.evaluator.type.value.DoubleValue;
import org.powerflows.dmn.engine.evaluator.type.value.SpecifiedTypeValue;

public class DoubleConverter
extends BaseTypeConverter<Double> {
    @Override
    protected SpecifiedTypeValue<Double> createValue(Double value) {
        return new DoubleValue(value);
    }

    @Override
    protected SpecifiedTypeValue<Double> createValue(List<Double> values) {
        return new DoubleValue(values);
    }

    @Override
    protected Double convertSingleObject(Object unspecifiedValue) {
        double doubleValue;
        if (unspecifiedValue instanceof Number) {
            doubleValue = ((Number)unspecifiedValue).doubleValue();
        } else if (unspecifiedValue instanceof String) {
            doubleValue = Double.valueOf((String)unspecifiedValue);
        } else {
            throw new EvaluationException("Value " + unspecifiedValue + " is not double");
        }
        return doubleValue;
    }
}

