/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.io.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.powerflows.dmn.engine.model.decision.Decision;
import org.powerflows.dmn.engine.model.decision.HitPolicy;
import org.powerflows.dmn.engine.model.decision.expression.Expression;
import org.powerflows.dmn.engine.model.decision.expression.ExpressionType;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.field.Output;
import org.powerflows.dmn.engine.model.decision.field.ValueType;
import org.powerflows.dmn.engine.model.decision.rule.Rule;
import org.powerflows.dmn.engine.model.decision.rule.entry.InputEntry;
import org.powerflows.dmn.engine.model.decision.rule.entry.OutputEntry;
import org.powerflows.dmn.engine.reader.DecisionReadException;
import org.powerflows.dmn.io.DecisionToExternalModelConverter;
import org.powerflows.dmn.io.xml.model.XMLDecision;
import org.powerflows.dmn.io.xml.model.XMLInput;
import org.powerflows.dmn.io.xml.model.XMLInputEntry;
import org.powerflows.dmn.io.xml.model.XMLOutput;
import org.powerflows.dmn.io.xml.model.XMLOutputEntry;
import org.powerflows.dmn.io.xml.model.XMLRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLDecisionConverter
implements DecisionToExternalModelConverter<XMLDecision> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XMLDecisionConverter.class);
    private static final Map<String, HitPolicy> OMG_HITPOLICY_MAPPING;
    private static final Map<String, ExpressionType> EXPRESSION_TYPE_MAPPING;
    private final HitPolicy defaultHitPolicy = HitPolicy.UNIQUE;
    private final ExpressionType defaultExpressionType = ExpressionType.FEEL;

    @Override
    public XMLDecision to(Decision decision) {
        throw new UnsupportedOperationException("Serialization is not supported");
    }

    @Override
    public Decision from(XMLDecision xmlDecision) {
        Decision.Builder builder = (Decision.Builder)((Decision.Builder)((Decision.Builder)Decision.builder().id(xmlDecision.getId())).name(xmlDecision.getName())).hitPolicy(this.makeHitPolicy(xmlDecision));
        this.processRules(builder, xmlDecision.getDecisionTable().getInputs(), xmlDecision.getDecisionTable().getOutputs(), xmlDecision.getDecisionTable().getRules());
        return (Decision)builder.build();
    }

    private Supplier<String> makeSequenceNameSupplier(final String prefix) {
        return new Supplier<String>(){
            private int count = 0;

            @Override
            public String get() {
                return prefix + this.count++;
            }

            public String toString() {
                return prefix + this.count;
            }
        };
    }

    private void processRules(Decision.Builder builder, List<XMLInput> inputs, List<XMLOutput> outputs, List<XMLRule> rules) {
        LinkedHashSet inputNames = new LinkedHashSet();
        Supplier<String> inputNameSequence = this.makeSequenceNameSupplier("input_");
        inputs.forEach(input -> {
            String name = this.selectOrCreateUniqueName(inputNames, input.getId(), null, input.getLabel(), inputNameSequence);
            builder.withInput(inputBuilder -> {
                if (input.getInputVariable() != null && !input.getInputVariable().trim().isEmpty()) {
                    inputBuilder.nameAlias(input.getInputVariable());
                }
                return (Input)((Input.Builder)((Input.Builder)((Input.Builder)inputBuilder.description(input.getLabel())).name(name)).withExpression(expressionBuilder -> (Expression)((Expression.Builder)((Expression.Builder)expressionBuilder.value((Serializable)((Object)input.getInputExpression().getText()))).type(this.resolveExpressionType(input.getInputExpression().getExpressionLanguage()))).build()).type(this.resolveType(input.getInputExpression().getTypeRef()))).build();
            });
        });
        LinkedHashSet outputNames = new LinkedHashSet();
        Supplier<String> outputNameSequence = this.makeSequenceNameSupplier("output_");
        outputs.forEach(output -> {
            String name = this.selectOrCreateUniqueName(outputNames, output.getId(), output.getName(), output.getLabel(), outputNameSequence);
            builder.withOutput(outputBuilder -> (Output)((Output.Builder)((Output.Builder)((Output.Builder)outputBuilder.description(output.getLabel())).type(this.resolveType(output.getTypeRef()))).name(name)).build());
        });
        rules.forEach(this.ruleProcessor(new ArrayList<String>(inputNames), new ArrayList<String>(outputNames), builder));
    }

    private String selectOrCreateUniqueName(Set<String> names, String id, String name, String label, Supplier<String> nameSequence) {
        String resultName;
        if (label != null) {
            String sanitizedLabel = label.replaceAll("[^a-zA-Z0-9\\-]", "_");
            if (names.contains(sanitizedLabel)) {
                log.warn("Names collection {} already contains name {}, using one from sequence {}", new Object[]{names, sanitizedLabel, nameSequence});
                resultName = this.getNextUniqueName(nameSequence, names);
            } else {
                resultName = sanitizedLabel;
            }
        } else if (name != null) {
            if (names.contains(name)) {
                log.warn("Names collection {} already contains name {}, using one from sequence {}", new Object[]{names, name, nameSequence});
                resultName = this.getNextUniqueName(nameSequence, names);
            } else {
                resultName = name.replaceAll("\\s", "_");
            }
        } else if (id != null) {
            if (names.contains(id)) {
                throw new DecisionReadException("Non unique element id: " + id);
            }
            resultName = id;
        } else {
            resultName = this.getNextUniqueName(nameSequence, names);
        }
        names.add(resultName);
        return resultName;
    }

    private String getNextUniqueName(Supplier<String> nameSequence, Set<String> names) {
        String name;
        while (names.contains(name = nameSequence.get())) {
        }
        return name;
    }

    private Consumer<XMLRule> ruleProcessor(List<String> inputNames, List<String> outputNames, Decision.Builder builder) {
        log.debug("Created rule processor for inputs: {}, and outputs: {}", inputNames, outputNames);
        return rule -> {
            log.debug("Processing rule: {}" + rule);
            builder.withRule(ruleBuilder -> {
                this.processInputEntries(rule.getInputEntries(), inputNames, rule.getId(), (Rule.Builder)ruleBuilder);
                this.processOutputEntries(rule.getOutputEntries(), outputNames, rule.getId(), (Rule.Builder)ruleBuilder);
                return (Rule)((Rule.Builder)ruleBuilder.description(rule.getDescription())).build();
            });
        };
    }

    private void processOutputEntries(List<XMLOutputEntry> outputEntries, List<String> outputNames, String id, Rule.Builder ruleBuilder) {
        if (outputEntries.size() != outputNames.size()) {
            throw new DecisionReadException("Invalid number of outputs in rule " + id);
        }
        for (int idx = 0; idx < outputEntries.size(); ++idx) {
            XMLOutputEntry outputEntry = outputEntries.get(idx);
            String name = outputNames.get(idx);
            ruleBuilder.withOutputEntry(entryBuilder -> (OutputEntry)((OutputEntry.Builder)entryBuilder.name(name)).withExpression(expressionBuilder -> (Expression)((Expression.Builder)((Expression.Builder)expressionBuilder.type(this.resolveExpressionType(outputEntry.getExpressionLanguage()))).value((Serializable)((Object)(this.isNotBlank(outputEntry.getExpression()) ? outputEntry.getExpression() : null)))).build()).build());
        }
    }

    private void processInputEntries(List<XMLInputEntry> inputEntries, List<String> inputNames, String id, Rule.Builder ruleBuilder) {
        if (inputEntries.size() != inputNames.size()) {
            throw new DecisionReadException("Invalid number of inputs in rule " + id);
        }
        for (int idx = 0; idx < inputEntries.size(); ++idx) {
            XMLInputEntry inputEntry = inputEntries.get(idx);
            if (!this.isNotBlank(inputEntry.getExpression())) continue;
            String name = inputNames.get(idx);
            ruleBuilder.withInputEntry(entryBuilder -> (InputEntry)((InputEntry.Builder)entryBuilder.name(name)).withExpression(expressionBuilder -> (Expression)((Expression.Builder)((Expression.Builder)expressionBuilder.type(this.resolveExpressionType(inputEntry.getExpressionLanguage()))).value((Serializable)((Object)inputEntry.getExpression()))).build()).build());
        }
    }

    private ExpressionType resolveExpressionType(String expressionLanguage) {
        if (expressionLanguage == null) {
            return this.defaultExpressionType;
        }
        return EXPRESSION_TYPE_MAPPING.getOrDefault(expressionLanguage.toLowerCase(), this.defaultExpressionType);
    }

    private boolean isNotBlank(String text) {
        return text != null && !text.trim().isEmpty();
    }

    private ValueType resolveType(String typeRef) {
        if (typeRef == null) {
            return ValueType.STRING;
        }
        return Arrays.stream(ValueType.values()).filter(v -> v.name().equalsIgnoreCase(typeRef)).findFirst().orElseGet(() -> {
            throw new DecisionReadException("Unable to resolve typeRef " + typeRef + " to PowerFlows Type");
        });
    }

    private HitPolicy makeHitPolicy(XMLDecision externalModel) {
        String hitPolicy = externalModel.getDecisionTable().getHitPolicy();
        return OMG_HITPOLICY_MAPPING.getOrDefault(hitPolicy, this.defaultHitPolicy);
    }

    static {
        HashMap<String, Enum> mapping = new HashMap<String, Enum>();
        mapping.put("UNIQUE", HitPolicy.UNIQUE);
        mapping.put("FIRST", HitPolicy.FIRST);
        mapping.put("PRIORITY", HitPolicy.PRIORITY);
        mapping.put("ANY", HitPolicy.ANY);
        mapping.put("COLLECT", HitPolicy.COLLECT);
        mapping.put("RULE ORDER", HitPolicy.RULE_ORDER);
        mapping.put("OUTPUT ORDER", HitPolicy.OUTPUT_ORDER);
        OMG_HITPOLICY_MAPPING = Collections.unmodifiableMap(mapping);
        mapping = new HashMap();
        mapping.put("feel", ExpressionType.FEEL);
        mapping.put("groovy", ExpressionType.GROOVY);
        mapping.put("javascript", ExpressionType.JAVASCRIPT);
        mapping.put("juel", ExpressionType.JUEL);
        EXPRESSION_TYPE_MAPPING = Collections.unmodifiableMap(mapping);
    }
}

