/*
 * Copyright 2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an
 * "AS IS" BASIS,  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.powertac.tariffmarket;

import java.util.List;

import org.apache.log4j.Logger;
import org.powertac.common.Competition;
import org.powertac.common.PluginConfig;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.ServerProperties;
import org.powertac.common.repo.PluginConfigRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TariffMarketInitializationService 
    implements InitializationService
{
  static private Logger log = Logger.getLogger(TariffMarketInitializationService.class.getName());

  @Autowired
  private TariffMarketService tariffMarketService;
  
  @Autowired
  private PluginConfigRepo pluginConfigRepo;
  
  @Autowired
  private ServerProperties serverProps;

  public void setDefaults ()
  {
    double publicationFee =
        serverProps.getDoubleProperty("tariffMarket.publicationFee", -100.0);
    double revocationFee =
        serverProps.getDoubleProperty("tariffMarket.revocationFee", -100.0);
    int publicationInterval =
        serverProps.getIntegerProperty("tariffMarket.publicationInterval", 6);
    int publicationOffset =
        serverProps.getIntegerProperty("tariffMarket.publicationOffset", 1);
    pluginConfigRepo.makePluginConfig("TariffMarket", "")
            .addConfiguration("tariffPublicationFee",
                              Double.toString(publicationFee))
            .addConfiguration("tariffRevocationFee",
                              Double.toString(revocationFee))
            .addConfiguration("publicationInterval",
                              Integer.toString(publicationInterval))
            .addConfiguration("publicationOffset",
                              Integer.toString(publicationOffset));
  }
  
  public String initialize (Competition competition, List<String> completedInits)
  {
    int index = completedInits.indexOf("AccountingService");
    if (index == -1) {
      return null;
    }
    PluginConfig tariffMarketConfig = pluginConfigRepo.findByRoleName("TariffMarket");
    if (tariffMarketConfig == null) {
      log.error("PluginConfig for TariffMarket does not exist");
    }
    else {
      tariffMarketService.init(tariffMarketConfig);
      return "TariffMarket";
    }
    return "fail";
  }
  
  public void shutDown ()
  {
    //tariffMarketService.shutDown();
  }
}
