/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.accounting;

import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.accounting.AccountingService;
import org.powertac.common.Competition;
import org.powertac.common.PluginConfig;
import org.powertac.common.RandomSeed;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.ServerProperties;
import org.powertac.common.repo.PluginConfigRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccountingInitializationService
implements InitializationService {
    private static Logger log = Logger.getLogger((String)AccountingInitializationService.class.getName());
    @Autowired
    private AccountingService accountingService;
    @Autowired
    private PluginConfigRepo pluginConfigRepo;
    @Autowired
    private RandomSeedRepo randomSeedService;
    private RandomSeed randomGen;
    @Autowired
    private ServerProperties serverProps;
    private double minInterest = 0.04;
    private double maxInterest = 0.12;

    public void setDefaults() {
        this.randomGen = this.randomSeedService.getRandomSeed("AccountingInitializationService", 0L, "interest");
        double interest = this.minInterest + this.randomGen.nextDouble() * (this.maxInterest - this.minInterest);
        interest = this.serverProps.getDoubleProperty("accounting.interest", Double.valueOf(interest));
        log.info((Object)("bank interest: " + interest));
        this.pluginConfigRepo.makePluginConfig("AccountingService", "init").addConfiguration("bankInterest", Double.toString(interest));
    }

    public String initialize(Competition competition, List<String> completedInits) {
        PluginConfig accountingConfig = this.pluginConfigRepo.findByRoleName("AccountingService");
        if (accountingConfig != null) {
            this.accountingService.init(accountingConfig);
            return "AccountingService";
        }
        log.error((Object)"PluginConfig for AccountingService does not exist");
        return "fail";
    }

    public double getMinInterest() {
        return this.minInterest;
    }

    public AccountingInitializationService setMinInterest(double minInterest) {
        this.minInterest = minInterest;
        return this;
    }

    public double getMaxInterest() {
        return this.maxInterest;
    }

    public AccountingInitializationService setMaxInterest(double maxInterest) {
        this.maxInterest = maxInterest;
        return this;
    }
}

