/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.accounting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.BalancingTransaction;
import org.powertac.common.BankTransaction;
import org.powertac.common.Broker;
import org.powertac.common.BrokerTransaction;
import org.powertac.common.CashPosition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.DistributionTransaction;
import org.powertac.common.MarketPosition;
import org.powertac.common.MarketTransaction;
import org.powertac.common.PluginConfig;
import org.powertac.common.Tariff;
import org.powertac.common.TariffTransaction;
import org.powertac.common.TimeService;
import org.powertac.common.Timeslot;
import org.powertac.common.interfaces.Accounting;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.util.MessageDispatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccountingService
extends TimeslotPhaseProcessor
implements Accounting {
    private static Logger log = Logger.getLogger((String)AccountingService.class.getName());
    @Autowired
    private TimeService timeService;
    @Autowired
    private TariffRepo tariffRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private BrokerRepo brokerRepo;
    @Autowired
    private BrokerProxy brokerProxyService;
    private ArrayList<BrokerTransaction> pendingTransactions = new ArrayList();
    private double bankInterest = 0.0;
    private int simulationPhase = 3;

    public void init(PluginConfig config) {
        this.pendingTransactions.clear();
        this.bankInterest = config.getDoubleValue("bankInterest", Double.valueOf(this.bankInterest));
        super.init();
    }

    public double getBankInterest() {
        return this.bankInterest;
    }

    public synchronized MarketTransaction addMarketTransaction(Broker broker, Timeslot timeslot, double mWh, double price) {
        MarketTransaction mtx = new MarketTransaction(broker, this.timeService.getCurrentTime(), timeslot, mWh, price);
        this.pendingTransactions.add((BrokerTransaction)mtx);
        return mtx;
    }

    public synchronized TariffTransaction addTariffTransaction(TariffTransaction.Type txType, Tariff tariff, CustomerInfo customer, int customerCount, double kWh, double charge) {
        TariffTransaction ttx = new TariffTransaction(tariff.getBroker(), this.timeService.getCurrentTime(), txType, this.tariffRepo.findSpecificationById(tariff.getSpecId()), customer, customerCount, kWh, charge);
        this.pendingTransactions.add((BrokerTransaction)ttx);
        return ttx;
    }

    public synchronized DistributionTransaction addDistributionTransaction(Broker broker, double kWh, double charge) {
        DistributionTransaction dtx = new DistributionTransaction(broker, this.timeService.getCurrentTime(), kWh, charge);
        this.pendingTransactions.add((BrokerTransaction)dtx);
        return dtx;
    }

    public synchronized BalancingTransaction addBalancingTransaction(Broker broker, double kWh, double charge) {
        BalancingTransaction btx = new BalancingTransaction(broker, this.timeService.getCurrentTime(), kWh, charge);
        this.pendingTransactions.add((BrokerTransaction)btx);
        return btx;
    }

    public synchronized double getCurrentNetLoad(Broker broker) {
        double netLoad = 0.0;
        for (BrokerTransaction btx : this.pendingTransactions) {
            TariffTransaction ttx;
            if (!(btx instanceof TariffTransaction) || (ttx = (TariffTransaction)btx).getBroker().getUsername() != broker.getUsername() || ttx.getTxType() != TariffTransaction.Type.CONSUME && ttx.getTxType() != TariffTransaction.Type.PRODUCE) continue;
            netLoad += ttx.getKWh();
        }
        log.info((Object)("net load for " + broker.getUsername() + ": " + netLoad));
        return netLoad;
    }

    public synchronized double getCurrentMarketPosition(Broker broker) {
        Timeslot current = this.timeslotRepo.currentTimeslot();
        log.debug((Object)("current timeslot: " + current.getSerialNumber()));
        MarketPosition position = broker.findMarketPositionByTimeslot(current);
        if (position == null) {
            log.debug((Object)("null position for ts " + current.getSerialNumber()));
            return 0.0;
        }
        log.info((Object)("market position for " + broker.getUsername() + ": " + position.getOverallBalance()));
        return position.getOverallBalance();
    }

    public void activate(Instant time, int phaseNumber) {
        log.info((Object)("Activate: " + this.pendingTransactions.size() + " messages"));
        HashMap brokerMsg = new HashMap();
        for (Broker broker : this.brokerRepo.list()) {
            brokerMsg.put(broker, new ArrayList());
        }
        for (BrokerTransaction tx : this.getPendingTransactionList()) {
            if (tx.getBroker() == null) {
                log.error((Object)("tx " + tx.getClass().getName() + ":" + tx.getId() + " has null broker"));
            }
            if (brokerMsg.get(tx.getBroker()) == null) {
                log.error((Object)("tx " + tx.getClass().getName() + ":" + tx.getId() + " has unknown broker " + tx.getBroker().getUsername()));
            }
            ((List)brokerMsg.get(tx.getBroker())).add(tx);
            MessageDispatcher.dispatch((Object)((Object)this), (String)"processTransaction", (Object[])new Object[]{tx, brokerMsg.get(tx.getBroker())});
        }
        double rate = this.bankInterest / 365.0;
        for (Broker broker : this.brokerRepo.list()) {
            if (this.timeService.getHourOfDay() == 0) {
                double brokerRate = rate;
                CashPosition cash = broker.getCash();
                if (cash.getBalance() >= 0.0) {
                    brokerRate /= 2.0;
                }
                double interest = cash.getBalance() * brokerRate;
                ((List)brokerMsg.get(broker)).add(new BankTransaction(broker, interest, this.timeService.getCurrentTime()));
                cash.deposit(interest);
            }
            ((List)brokerMsg.get(broker)).add(broker.getCash());
            log.info((Object)("Sending " + ((List)brokerMsg.get(broker)).size() + " messages to " + broker.getUsername()));
            this.brokerProxyService.sendMessages(broker, (List)brokerMsg.get(broker));
        }
    }

    private synchronized List<BrokerTransaction> getPendingTransactionList() {
        ArrayList<BrokerTransaction> result = new ArrayList<BrokerTransaction>(this.pendingTransactions);
        this.pendingTransactions.clear();
        return result;
    }

    public void processTransaction(TariffTransaction tx, ArrayList<Object> messages) {
        this.updateCash(tx.getBroker(), tx.getCharge());
    }

    public void processTransaction(BalancingTransaction tx, ArrayList<Object> messages) {
        this.updateCash(tx.getBroker(), tx.getCharge());
    }

    public void processTransaction(DistributionTransaction tx, ArrayList<Object> messages) {
        this.updateCash(tx.getBroker(), tx.getCharge());
    }

    public void processTransaction(MarketTransaction tx, ArrayList<Object> messages) {
        Broker broker = tx.getBroker();
        this.updateCash(broker, tx.getPrice() * Math.abs(tx.getMWh()));
        MarketPosition mkt = broker.findMarketPositionByTimeslot(tx.getTimeslot());
        if (mkt == null) {
            mkt = new MarketPosition(broker, tx.getTimeslot(), tx.getMWh());
            log.debug((Object)("New MarketPosition(" + broker.getUsername() + ", " + tx.getTimeslot().getSerialNumber() + "): " + mkt.getId()));
            broker.addMarketPosition(mkt, tx.getTimeslot());
            messages.add(mkt);
        } else {
            mkt.updateBalance(tx.getMWh());
        }
    }

    private void updateCash(Broker broker, double amount) {
        CashPosition cash = broker.getCash();
        cash.deposit(amount);
    }

    public void processTransaction(BankTransaction tx, ArrayList<Object> messages) {
        log.error((Object)("tx " + tx.toString() + " calls processTransaction - should not happen"));
    }

    List<BrokerTransaction> getPendingTransactions() {
        return this.pendingTransactions;
    }

    int getSimulationPhase() {
        return this.simulationPhase;
    }

    void setBankInterest(double value) {
        this.bankInterest = value;
    }
}

