/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.tariffmarket;

import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.common.Competition;
import org.powertac.common.PluginConfig;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.ServerProperties;
import org.powertac.common.repo.PluginConfigRepo;
import org.powertac.tariffmarket.TariffMarketService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TariffMarketInitializationService
implements InitializationService {
    private static Logger log = Logger.getLogger((String)TariffMarketInitializationService.class.getName());
    @Autowired
    private TariffMarketService tariffMarketService;
    @Autowired
    private PluginConfigRepo pluginConfigRepo;
    @Autowired
    private ServerProperties serverProps;

    public void setDefaults() {
        double publicationFee = this.serverProps.getDoubleProperty("tariffMarket.publicationFee", Double.valueOf(-100.0));
        double revocationFee = this.serverProps.getDoubleProperty("tariffMarket.revocationFee", Double.valueOf(-100.0));
        int publicationInterval = this.serverProps.getIntegerProperty("tariffMarket.publicationInterval", Integer.valueOf(6));
        int publicationOffset = this.serverProps.getIntegerProperty("tariffMarket.publicationOffset", Integer.valueOf(1));
        this.pluginConfigRepo.makePluginConfig("TariffMarket", "").addConfiguration("tariffPublicationFee", Double.toString(publicationFee)).addConfiguration("tariffRevocationFee", Double.toString(revocationFee)).addConfiguration("publicationInterval", Integer.toString(publicationInterval)).addConfiguration("publicationOffset", Integer.toString(publicationOffset));
    }

    public String initialize(Competition competition, List<String> completedInits) {
        int index = completedInits.indexOf("AccountingService");
        if (index == -1) {
            return null;
        }
        PluginConfig tariffMarketConfig = this.pluginConfigRepo.findByRoleName("TariffMarket");
        if (tariffMarketConfig != null) {
            this.tariffMarketService.init(tariffMarketConfig);
            return "TariffMarket";
        }
        log.error((Object)"PluginConfig for TariffMarket does not exist");
        return "fail";
    }

    public void shutDown() {
    }
}

