/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.tariffmarket;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.powertac.common.Broker;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.Tariff;
import org.powertac.common.TariffMessage;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TariffSubscription;
import org.powertac.common.TariffTransaction;
import org.powertac.common.TimeService;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.Accounting;
import org.powertac.common.interfaces.BrokerMessageListener;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.NewTariffListener;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.msg.TariffExpire;
import org.powertac.common.msg.TariffRevoke;
import org.powertac.common.msg.TariffStatus;
import org.powertac.common.msg.TariffUpdate;
import org.powertac.common.msg.VariableRateUpdate;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.util.MessageDispatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TariffMarketService
extends TimeslotPhaseProcessor
implements TariffMarket,
BrokerMessageListener,
InitializationService {
    private static Logger log = Logger.getLogger((String)TariffMarketService.class.getName());
    @Autowired
    private TimeService timeService;
    @Autowired
    private Accounting accountingService;
    @Autowired
    private BrokerProxy brokerProxyService;
    @Autowired
    private TariffRepo tariffRepo;
    @Autowired
    private TariffSubscriptionRepo tariffSubscriptionRepo;
    @Autowired
    private ServerConfiguration serverProps;
    @Autowired
    private RandomSeedRepo randomSeedService;
    private HashMap<PowerType, Long> defaultTariff;
    @ConfigurableValue(valueType="Double", description="low end of tariff publication fee range")
    private double minPublicationFee = -100.0;
    @ConfigurableValue(valueType="Double", description="high end of tariff publication fee range")
    private double maxPublicationFee = -500.0;
    @ConfigurableValue(valueType="Double", publish=true, description="set publication fee directly to override random selection")
    private Double publicationFee = null;
    @ConfigurableValue(valueType="Double", description="low end of tariff revocation fee range")
    private double minRevocationFee = -100.0;
    @ConfigurableValue(valueType="Double", description="high end of tariff revocation fee range")
    private double maxRevocationFee = -500.0;
    @ConfigurableValue(valueType="Double", publish=true, description="Set revocation fee directly to override random selection")
    private Double revocationFee = null;
    private int publicationInterval = 6;
    private int publicationOffset = 0;
    private boolean firstPublication;
    private List<NewTariffListener> registrations = new ArrayList<NewTariffListener>();

    public String initialize(Competition competition, List<String> completedInits) {
        int index = completedInits.indexOf("AccountingService");
        if (index == -1) {
            return null;
        }
        this.defaultTariff = new HashMap();
        this.brokerProxyService.registerBrokerTariffListener((BrokerMessageListener)this);
        this.firstPublication = false;
        this.registrations.clear();
        this.publicationFee = null;
        this.revocationFee = null;
        super.init();
        this.serverProps.configureMe((Object)this);
        RandomSeed random = this.randomSeedService.getRandomSeed("AccountingService", 0L, "interest");
        if (this.publicationFee == null) {
            this.publicationFee = this.minPublicationFee + random.nextDouble() * (this.maxPublicationFee - this.minPublicationFee);
            log.info((Object)("set publication fee: " + this.publicationFee));
        }
        if (this.revocationFee == null) {
            this.revocationFee = this.minRevocationFee + random.nextDouble() * (this.maxRevocationFee - this.minRevocationFee);
            log.info((Object)("set revocation fee: " + this.revocationFee));
        }
        this.serverProps.publishConfiguration((Object)this);
        return "TariffMarket";
    }

    public double getMinPublicationFee() {
        return this.minPublicationFee;
    }

    public double getMaxPublicationFee() {
        return this.maxPublicationFee;
    }

    public Double getPublicationFee() {
        return this.publicationFee;
    }

    public double getMinRevocationFee() {
        return this.minRevocationFee;
    }

    public double getMaxRevocationFee() {
        return this.maxRevocationFee;
    }

    public Double getRevocationFee() {
        return this.revocationFee;
    }

    public int getPublicationInterval() {
        return this.publicationInterval;
    }

    @ConfigurableValue(valueType="Integer", description="Number of timeslots between tariff publication events. Must be at most 24.")
    public void setPublicationInterval(int interval) {
        if (interval > 24) {
            log.error((Object)("tariff publication interval " + interval + " > 24 hr"));
            interval = 24;
        }
        this.publicationInterval = interval;
    }

    public int getPublicationOffset() {
        return this.publicationOffset;
    }

    @ConfigurableValue(valueType="Integer", description="Number of timeslots from the first timeslot to delay the first publication event. It does not work well to make this zero, because brokers do not have an opportunity to post tariffs in timeslot 0.")
    public void setPublicationOffset(int offset) {
        if (offset >= this.publicationInterval) {
            log.error((Object)("tariff publication offset " + this.publicationOffset + " >= publication interval " + offset));
        } else {
            this.publicationOffset = offset;
        }
    }

    List<NewTariffListener> getRegistrations() {
        return this.registrations;
    }

    public void receiveMessage(Object msg) {
        if (msg != null && msg instanceof TariffMessage) {
            TariffMessage message = (TariffMessage)msg;
            TariffStatus result = (TariffStatus)MessageDispatcher.dispatch((Object)((Object)this), (String)"processTariff", (Object[])new Object[]{message});
            if (result == null) {
                result = new TariffStatus(message.getBroker(), 0L, message.getId(), TariffStatus.Status.illegalOperation);
            }
            if (result != null) {
                this.brokerProxyService.sendMessage(result.getBroker(), (Object)result);
            }
        }
    }

    public TariffStatus processTariff(TariffSpecification spec) {
        this.tariffRepo.addSpecification(spec);
        Tariff tariff = new Tariff(spec);
        this.tariffRepo.addTariff(tariff);
        tariff.init();
        log.info((Object)("new tariff " + spec.getId()));
        this.accountingService.addTariffTransaction(TariffTransaction.Type.PUBLISH, tariff, null, 0, 0.0, this.publicationFee.doubleValue());
        return new TariffStatus(spec.getBroker(), spec.getId(), spec.getId(), TariffStatus.Status.success);
    }

    public TariffStatus processTariff(TariffExpire update) {
        ValidationResult result = this.validateUpdate((TariffUpdate)update);
        if (result.tariff == null) {
            return result.message;
        }
        Instant newExp = update.getNewExpiration();
        if (newExp != null && newExp.isBefore((ReadableInstant)this.timeService.getCurrentTime())) {
            log.warn((Object)("attempt to set expiration for tariff " + result.tariff.getId() + " in the past:" + newExp.toString()));
            return new TariffStatus(update.getBroker(), update.getTariffId(), update.getId(), TariffStatus.Status.invalidUpdate).withMessage("attempt to set expiration in the past");
        }
        result.tariff.setExpiration(newExp);
        log.info((Object)("Tariff " + update.getTariffId() + "now expires at " + new DateTime((Object)result.tariff.getExpiration(), DateTimeZone.UTC).toString()));
        return this.success((TariffUpdate)update);
    }

    public TariffStatus processTariff(TariffRevoke update) {
        ValidationResult result = this.validateUpdate((TariffUpdate)update);
        if (result.tariff == null) {
            return result.message;
        }
        result.tariff.setState(Tariff.State.KILLED);
        log.info((Object)("Revoke tariff " + update.getTariffId()));
        List activeSubscriptions = this.tariffSubscriptionRepo.findSubscriptionsForTariff(result.tariff);
        Iterator subs = activeSubscriptions.iterator();
        while (subs.hasNext()) {
            TariffSubscription sub = (TariffSubscription)subs.next();
            if (sub.getCustomersCommitted() > 0) continue;
            subs.remove();
        }
        if (activeSubscriptions.size() > 0) {
            log.info((Object)("Revoked tariff has " + activeSubscriptions.size() + " active subscriptions"));
            this.accountingService.addTariffTransaction(TariffTransaction.Type.REVOKE, result.tariff, null, 0, 0.0, this.revocationFee.doubleValue());
        }
        return this.success((TariffUpdate)update);
    }

    public TariffStatus processTariff(VariableRateUpdate update) {
        ValidationResult result = this.validateUpdate((TariffUpdate)update);
        if (result.tariff == null) {
            return result.message;
        }
        if (result.tariff.addHourlyCharge(update.getHourlyCharge(), update.getRateId())) {
            return this.success((TariffUpdate)update);
        }
        return new TariffStatus(update.getBroker(), update.getTariffId(), update.getId(), TariffStatus.Status.invalidUpdate).withMessage("update: could not add hourly charge");
    }

    public void registerNewTariffListener(NewTariffListener listener) {
        this.registrations.add(listener);
    }

    public void activate(Instant time, int phase) {
        log.info((Object)"Activate");
        long msec = this.timeService.getCurrentTime().getMillis();
        if (!this.firstPublication || msec / 3600000L % (long)this.publicationInterval == (long)this.publicationOffset) {
            this.publishTariffs();
            this.firstPublication = true;
        }
    }

    private void publishTariffs() {
        List publishedTariffs = this.tariffRepo.findTariffsByState(Tariff.State.PENDING);
        log.info((Object)("publishing " + publishedTariffs.size() + " new tariffs"));
        for (Tariff tariff : publishedTariffs) {
            tariff.setState(Tariff.State.OFFERED);
        }
        ArrayList<TariffSpecification> publishedTariffSpecs = new ArrayList<TariffSpecification>();
        for (Tariff tariff : publishedTariffs) {
            TariffSpecification spec = tariff.getTariffSpecification();
            publishedTariffSpecs.add(spec);
            log.info((Object)("publishing spec " + spec.getId() + " broker: " + spec.getBroker().getUsername() + ", exp: " + spec.getExpiration()));
        }
        for (NewTariffListener listener : this.registrations) {
            listener.publishNewTariffs(publishedTariffs);
        }
        this.brokerProxyService.broadcastMessages(publishedTariffSpecs);
    }

    public TariffSubscription subscribeToTariff(Tariff tariff, CustomerInfo customer, int customerCount) {
        if (tariff.isExpired()) {
            return null;
        }
        TariffSubscription sub = this.tariffSubscriptionRepo.getSubscription(customer, tariff);
        sub.subscribe(customerCount);
        return sub;
    }

    public List<Tariff> getActiveTariffList(PowerType type) {
        return this.tariffRepo.findActiveTariffs(type);
    }

    public Tariff getDefaultTariff(PowerType type) {
        Long defaultId = this.defaultTariff.get(type);
        if (defaultId == null) {
            return null;
        }
        return this.tariffRepo.findTariffById(defaultId.longValue());
    }

    public boolean setDefaultTariff(TariffSpecification newSpec) {
        this.tariffRepo.addSpecification(newSpec);
        Tariff tariff = new Tariff(newSpec);
        tariff.init();
        this.tariffRepo.addTariff(tariff);
        this.defaultTariff.put(newSpec.getPowerType(), tariff.getId());
        return true;
    }

    private TariffStatus success(TariffUpdate update) {
        Broker broker = update.getBroker();
        return new TariffStatus(broker, update.getTariffId(), update.getId(), TariffStatus.Status.success);
    }

    private ValidationResult validateUpdate(TariffUpdate update) {
        Broker broker = update.getBroker();
        Tariff tariff = this.tariffRepo.findTariffById(update.getTariffId());
        if (tariff == null) {
            log.error((Object)("update - no such tariff " + update.getTariffId() + ", broker " + update.getBroker().getUsername()));
            return new ValidationResult(null, new TariffStatus(broker, update.getTariffId(), update.getId(), TariffStatus.Status.noSuchTariff));
        }
        return new ValidationResult(tariff, null);
    }

    public void setDefaults() {
    }

    private class ValidationResult {
        Tariff tariff;
        TariffStatus message;

        ValidationResult(Tariff tariff, TariffStatus msg) {
            this.tariff = tariff;
            this.message = msg;
        }
    }
}

