/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.tariffmarket;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSubscription;
import org.powertac.common.interfaces.Accounting;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.CapacityControl;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.msg.BalancingControlEvent;
import org.powertac.common.msg.BalancingOrder;
import org.powertac.common.msg.EconomicControlEvent;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CapacityControlService
extends TimeslotPhaseProcessor
implements CapacityControl,
InitializationService {
    private static Logger log = Logger.getLogger((String)CapacityControlService.class.getName());
    @Autowired
    Accounting accountingService;
    @Autowired
    TariffRepo tariffRepo;
    @Autowired
    TariffSubscriptionRepo tariffSubscriptionRepo;
    @Autowired
    TimeslotRepo timeslotRepo;
    @Autowired
    BrokerProxy brokerProxy;
    HashMap<Integer, List<EconomicControlEvent>> pendingEconomicControls = new HashMap();
    private double epsilon = 1.0E-6;

    public void exerciseBalancingControl(BalancingOrder order, double kwh, double payment) {
        if (Math.abs(kwh) < this.epsilon) {
            return;
        }
        Tariff tariff = this.tariffRepo.findTariffById(order.getTariffId());
        if (null == tariff) {
            log.error((Object)("Null tariff " + order.getTariffId() + " for balancing control"));
            return;
        }
        List subs = this.tariffSubscriptionRepo.findSubscriptionsForTariff(tariff);
        double curtailable = 0.0;
        HashMap<TariffSubscription, Double> amts = new HashMap<TariffSubscription, Double>();
        for (TariffSubscription sub : subs) {
            if (sub.getCustomersCommitted() <= 0) continue;
            double value = sub.getMaxRemainingCurtailment();
            amts.put(sub, value);
            curtailable += value;
        }
        if (Math.abs(curtailable) < this.epsilon) {
            log.warn((Object)"Unable to exercise balancing control: curtailable == 0");
            return;
        }
        for (TariffSubscription sub : subs) {
            if (sub.getCustomersCommitted() <= 0) continue;
            sub.postBalancingControl(kwh * (Double)amts.get(sub) / curtailable);
        }
        BalancingControlEvent bce = new BalancingControlEvent(tariff.getTariffSpec(), kwh, payment, this.timeslotRepo.currentTimeslot().getSerialNumber());
        this.brokerProxy.sendMessage(tariff.getBroker(), (Object)bce);
    }

    public void postEconomicControl(EconomicControlEvent event) {
        int current;
        int tsIndex = event.getTimeslotIndex();
        if (tsIndex < (current = this.timeslotRepo.currentTimeslot().getSerialNumber())) {
            log.warn((Object)("attempt to save old economic control for ts " + tsIndex + " during timeslot " + current));
            return;
        }
        List<EconomicControlEvent> tsList = this.pendingEconomicControls.get(tsIndex);
        if (null == tsList) {
            tsList = new ArrayList<EconomicControlEvent>();
            this.pendingEconomicControls.put(tsIndex, tsList);
        }
        tsList.add(event);
    }

    public double getCurtailableUsage(BalancingOrder order) {
        Tariff tariff = this.tariffRepo.findTariffById(order.getTariffId());
        if (null == tariff) {
            log.warn((Object)("Null tariff " + order.getTariffId() + " for balancing order"));
            return 0.0;
        }
        double result = 0.0;
        List subs = this.tariffSubscriptionRepo.findSubscriptionsForTariff(tariff);
        for (TariffSubscription sub : subs) {
            result += sub.getMaxRemainingCurtailment();
        }
        return result;
    }

    void exerciseEconomicControl(EconomicControlEvent event) {
        Tariff tariff = this.tariffRepo.findTariffById(event.getTariffId());
        if (null == tariff) {
            log.error((Object)("Null tariff " + event.getTariffId() + " for economic control"));
            return;
        }
        List subs = this.tariffSubscriptionRepo.findSubscriptionsForTariff(tariff);
        for (TariffSubscription sub : subs) {
            sub.postRatioControl(event.getCurtailmentRatio());
        }
    }

    public void activate(Instant time, int phaseNumber) {
        int tsIndex = this.timeslotRepo.currentTimeslot().getSerialNumber();
        List<EconomicControlEvent> controls = this.getControlsForTimeslot(tsIndex - 1);
        if (null != controls) {
            for (EconomicControlEvent event : controls) {
                log.warn((Object)("Expired economic control, ts=" + (tsIndex - 1) + ", broker=" + event.getBroker().getUsername()));
            }
            this.pendingEconomicControls.remove(tsIndex - 1);
        }
        if (null != (controls = this.getControlsForTimeslot(tsIndex))) {
            for (EconomicControlEvent event : controls) {
                Tariff tariff = this.tariffRepo.findTariffById(event.getTariffId());
                if (null == tariff) {
                    log.warn((Object)("Cannot find tariff " + event.getTariffId() + " in EconomicControlEvent " + event.getId() + " from " + event.getBroker().getUsername()));
                    continue;
                }
                for (TariffSubscription sub : this.tariffSubscriptionRepo.findSubscriptionsForTariff(tariff)) {
                    sub.postRatioControl(event.getCurtailmentRatio());
                }
            }
        }
    }

    List<EconomicControlEvent> getControlsForTimeslot(int timeslotIndex) {
        return this.pendingEconomicControls.get(timeslotIndex);
    }

    public void setDefaults() {
    }

    public String initialize(Competition competition, List<String> completedInits) {
        this.pendingEconomicControls.clear();
        return "CapacityControl";
    }
}

