/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.tariffmarket;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.powertac.common.Broker;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.Rate;
import org.powertac.common.Tariff;
import org.powertac.common.TariffMessage;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TariffSubscription;
import org.powertac.common.TariffTransaction;
import org.powertac.common.TimeService;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.Accounting;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.CapacityControl;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.NewTariffListener;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.msg.BalancingOrder;
import org.powertac.common.msg.EconomicControlEvent;
import org.powertac.common.msg.TariffExpire;
import org.powertac.common.msg.TariffRevoke;
import org.powertac.common.msg.TariffStatus;
import org.powertac.common.msg.TariffUpdate;
import org.powertac.common.msg.VariableRateUpdate;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.util.ListTools;
import org.powertac.util.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TariffMarketService
extends TimeslotPhaseProcessor
implements TariffMarket,
InitializationService {
    private static Logger log = Logger.getLogger((String)TariffMarketService.class.getName());
    @Autowired
    private TimeService timeService;
    @Autowired
    private Accounting accountingService;
    @Autowired
    private CapacityControl capacityControlService;
    @Autowired
    private BrokerProxy brokerProxyService;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private TariffRepo tariffRepo;
    @Autowired
    private TariffSubscriptionRepo tariffSubscriptionRepo;
    @Autowired
    private ServerConfiguration serverProps;
    @Autowired
    private RandomSeedRepo randomSeedService;
    private HashMap<PowerType, Long> defaultTariff;
    private ArrayList<Tariff> pendingRevokedTariffs = new ArrayList();
    private List<Tariff> revokedTariffs = null;
    private Instant lastRevokeProcess = new Instant(0L);
    @ConfigurableValue(valueType="Double", description="low end of tariff publication fee range")
    private double minPublicationFee = -100.0;
    @ConfigurableValue(valueType="Double", description="high end of tariff publication fee range")
    private double maxPublicationFee = -500.0;
    @ConfigurableValue(valueType="Double", publish=true, description="set publication fee directly to override random selection")
    private Double publicationFee = null;
    @ConfigurableValue(valueType="Double", description="low end of tariff revocation fee range")
    private double minRevocationFee = -100.0;
    @ConfigurableValue(valueType="Double", description="high end of tariff revocation fee range")
    private double maxRevocationFee = -500.0;
    @ConfigurableValue(valueType="Double", publish=true, description="Set revocation fee directly to override random selection")
    private Double revocationFee = null;
    private int publicationInterval = 6;
    private int publicationOffset = 0;
    private boolean firstPublication;
    private List<PendingSubscription> pendingSubscriptionEvents = new ArrayList<PendingSubscription>();
    private List<VariableRateUpdate> pendingVrus = new ArrayList<VariableRateUpdate>();
    private List<NewTariffListener> registrations = new ArrayList<NewTariffListener>();

    public String initialize(Competition competition, List<String> completedInits) {
        int index = completedInits.indexOf("AccountingService");
        if (index == -1) {
            return null;
        }
        this.defaultTariff = new HashMap();
        for (Class messageType : Arrays.asList(TariffSpecification.class, TariffExpire.class, TariffRevoke.class, VariableRateUpdate.class, EconomicControlEvent.class, BalancingOrder.class)) {
            this.brokerProxyService.registerBrokerMessageListener((Object)this, messageType);
        }
        this.firstPublication = false;
        this.registrations.clear();
        this.publicationFee = null;
        this.revocationFee = null;
        super.init();
        this.pendingSubscriptionEvents.clear();
        this.pendingRevokedTariffs.clear();
        this.pendingVrus.clear();
        this.revokedTariffs = null;
        this.lastRevokeProcess = new Instant(0L);
        this.serverProps.configureMe((Object)this);
        RandomSeed random = this.randomSeedService.getRandomSeed("TariffMarket", 0L, "fees");
        if (this.publicationFee == null) {
            this.publicationFee = this.minPublicationFee + random.nextDouble() * (this.maxPublicationFee - this.minPublicationFee);
            log.info((Object)("set publication fee: " + this.publicationFee));
        }
        if (this.revocationFee == null) {
            this.revocationFee = this.minRevocationFee + random.nextDouble() * (this.maxRevocationFee - this.minRevocationFee);
            log.info((Object)("set revocation fee: " + this.revocationFee));
        }
        this.serverProps.publishConfiguration((Object)this);
        return "TariffMarket";
    }

    public double getMinPublicationFee() {
        return this.minPublicationFee;
    }

    public double getMaxPublicationFee() {
        return this.maxPublicationFee;
    }

    public Double getPublicationFee() {
        return this.publicationFee;
    }

    public double getMinRevocationFee() {
        return this.minRevocationFee;
    }

    public double getMaxRevocationFee() {
        return this.maxRevocationFee;
    }

    public Double getRevocationFee() {
        return this.revocationFee;
    }

    public int getPublicationInterval() {
        return this.publicationInterval;
    }

    @ConfigurableValue(valueType="Integer", description="Number of timeslots between tariff publication events. Must be at most 24.")
    public void setPublicationInterval(int interval) {
        if (interval > 24) {
            log.error((Object)("tariff publication interval " + interval + " > 24 hr"));
            interval = 24;
        }
        this.publicationInterval = interval;
    }

    public int getPublicationOffset() {
        return this.publicationOffset;
    }

    @ConfigurableValue(valueType="Integer", description="Number of timeslots from the first timeslot to delay the first publication event. It does not work well to make this zero, because brokers do not have an opportunity to post tariffs in timeslot 0.")
    public void setPublicationOffset(int offset) {
        if (offset >= this.publicationInterval) {
            log.error((Object)("tariff publication offset " + this.publicationOffset + " >= publication interval " + offset));
        } else {
            this.publicationOffset = offset;
        }
    }

    List<NewTariffListener> getRegistrations() {
        return this.registrations;
    }

    public void handleMessage(TariffSpecification spec) {
        if (null != this.tariffRepo.findSpecificationById(spec.getId()) && !this.tariffRepo.isRemoved(spec.getId())) {
            log.warn((Object)("duplicate tariff spec from " + spec.getBroker().getUsername() + ", id = " + spec.getId()));
            this.send((TariffMessage)new TariffStatus(spec.getBroker(), spec.getId(), spec.getId(), TariffStatus.Status.invalidTariff));
            return;
        }
        if (null == spec.getRates()) {
            log.warn((Object)("no rates given for spec " + spec.getId()));
            this.send((TariffMessage)new TariffStatus(spec.getBroker(), spec.getId(), spec.getId(), TariffStatus.Status.invalidTariff));
            return;
        }
        for (Rate rate : spec.getRates()) {
            if (rate.getDailyBegin() < 24 && rate.getDailyEnd() < 24 && rate.getWeeklyBegin() != 0 && rate.getWeeklyBegin() <= 7 && rate.getWeeklyEnd() != 0 && rate.getWeeklyEnd() <= 7) continue;
            log.warn((Object)("invalid rate for spec " + spec.getId()));
            this.send((TariffMessage)new TariffStatus(spec.getBroker(), spec.getId(), spec.getId(), TariffStatus.Status.invalidTariff));
            return;
        }
        this.tariffRepo.addSpecification(spec);
        Tariff tariff = new Tariff(spec);
        tariff.init();
        log.info((Object)("new tariff " + spec.getId()));
        this.accountingService.addTariffTransaction(TariffTransaction.Type.PUBLISH, tariff, null, 0, 0.0, this.publicationFee.doubleValue());
        this.send((TariffMessage)new TariffStatus(spec.getBroker(), spec.getId(), spec.getId(), TariffStatus.Status.success));
    }

    public void handleMessage(TariffExpire update) {
        ValidationResult result = this.validateUpdate((TariffUpdate)update);
        if (result.tariff == null) {
            this.send((TariffMessage)result.message);
        } else {
            Instant newExp = update.getNewExpiration();
            if (newExp != null && newExp.isBefore((ReadableInstant)this.timeService.getCurrentTime())) {
                log.warn((Object)("attempt to set expiration for tariff " + result.tariff.getId() + " in the past:" + newExp.toString()));
                this.send((TariffMessage)new TariffStatus(update.getBroker(), update.getTariffId(), update.getId(), TariffStatus.Status.invalidUpdate).withMessage("attempt to set expiration in the past"));
            } else {
                result.tariff.setExpiration(newExp);
                log.info((Object)("Tariff " + update.getTariffId() + "now expires at " + new DateTime((Object)result.tariff.getExpiration(), DateTimeZone.UTC).toString()));
                this.success((TariffUpdate)update);
            }
        }
    }

    public void handleMessage(TariffRevoke update) {
        ValidationResult result = this.validateUpdate((TariffUpdate)update);
        if (result.tariff == null) {
            this.send((TariffMessage)result.message);
        } else {
            this.addPendingRevoke(result.tariff);
        }
        this.success((TariffUpdate)update);
    }

    public void handleMessage(VariableRateUpdate update) {
        ValidationResult result = this.validateUpdate((TariffUpdate)update);
        if (result.tariff == null) {
            this.send((TariffMessage)result.message);
        } else {
            this.addVru(update);
        }
    }

    public void handleMessage(EconomicControlEvent msg) {
        ValidationResult result = this.validateUpdate((TariffUpdate)msg);
        if (result.tariff == null) {
            this.send((TariffMessage)result.message);
            return;
        }
        int currentTimeslot = this.timeslotRepo.currentTimeslot().getSerialNumber();
        if (currentTimeslot > msg.getTimeslotIndex()) {
            log.warn((Object)("Curtailment requested in ts " + currentTimeslot + " for past timeslot " + msg.getTimeslotIndex()));
            this.send((TariffMessage)new TariffStatus(msg.getBroker(), msg.getTariffId(), msg.getId(), TariffStatus.Status.invalidUpdate).withMessage("control: specified timeslot in the past"));
            return;
        }
        this.capacityControlService.postEconomicControl(msg);
    }

    public void handleMessage(BalancingOrder msg) {
        ValidationResult result = this.validateUpdate((TariffUpdate)msg);
        if (result.tariff == null) {
            this.send((TariffMessage)result.message);
            return;
        }
        this.tariffRepo.addBalancingOrder(msg);
    }

    private synchronized void addPendingRevoke(Tariff tariff) {
        this.pendingRevokedTariffs.add(tariff);
    }

    private synchronized List<Tariff> getPendingRevokes() {
        Instant now = this.timeService.getCurrentTime();
        if (now.isAfter((ReadableInstant)this.lastRevokeProcess)) {
            this.lastRevokeProcess = now;
            ArrayList<Tariff> result = new ArrayList<Tariff>(this.pendingRevokedTariffs);
            this.pendingRevokedTariffs.clear();
            return result;
        }
        return null;
    }

    public void processRevokedTariffs() {
        List<Tariff> pending = this.getPendingRevokes();
        if (pending == null) {
            return;
        }
        this.revokedTariffs = pending;
        for (Tariff tariff : pending) {
            tariff.setState(Tariff.State.KILLED);
            log.info((Object)("Revoke tariff " + tariff.getId()));
            List activeSubscriptions = ListTools.filter((Collection)this.tariffSubscriptionRepo.findSubscriptionsForTariff(tariff), (Predicate)new Predicate<TariffSubscription>(){

                public boolean apply(TariffSubscription sub) {
                    return sub.getCustomersCommitted() > 0;
                }
            });
            if (activeSubscriptions.size() <= 0) continue;
            log.info((Object)("Revoked tariff " + tariff.getId() + " has " + activeSubscriptions.size() + " active subscriptions"));
            this.accountingService.addTariffTransaction(TariffTransaction.Type.REVOKE, tariff, null, 0, 0.0, this.revocationFee.doubleValue());
        }
    }

    void removeRevokedTariffs() {
        if (null == this.revokedTariffs) {
            return;
        }
        for (Tariff tariff : this.revokedTariffs) {
            this.tariffSubscriptionRepo.removeSubscriptionsForTariff(tariff);
            this.tariffRepo.removeTariff(tariff);
        }
        this.revokedTariffs = null;
    }

    public void registerNewTariffListener(NewTariffListener listener) {
        this.registrations.add(listener);
    }

    public void activate(Instant time, int phase) {
        log.info((Object)"Activate");
        this.processPendingSubscriptions();
        this.removeRevokedTariffs();
        this.processPendingVrus();
        long msec = this.timeService.getCurrentTime().getMillis();
        if (!this.firstPublication || msec / 3600000L % (long)this.publicationInterval == (long)this.publicationOffset) {
            this.publishTariffs();
            this.firstPublication = true;
        }
    }

    private void publishTariffs() {
        List publishedTariffs = this.tariffRepo.findTariffsByState(Tariff.State.PENDING);
        log.info((Object)("publishing " + publishedTariffs.size() + " new tariffs"));
        for (Tariff tariff : publishedTariffs) {
            tariff.setState(Tariff.State.OFFERED);
        }
        ArrayList<TariffSpecification> publishedTariffSpecs = new ArrayList<TariffSpecification>();
        for (Tariff tariff : publishedTariffs) {
            TariffSpecification spec = tariff.getTariffSpecification();
            publishedTariffSpecs.add(spec);
            log.info((Object)("publishing spec " + spec.getId() + " broker: " + spec.getBroker().getUsername() + ", exp: " + spec.getExpiration()));
        }
        for (NewTariffListener listener : this.registrations) {
            listener.publishNewTariffs(publishedTariffs);
        }
        this.brokerProxyService.broadcastMessages(publishedTariffSpecs);
    }

    public List<Tariff> getActiveTariffList(PowerType type) {
        return this.tariffRepo.findActiveTariffs(type);
    }

    public Tariff getDefaultTariff(PowerType type) {
        Long defaultId = this.defaultTariff.get(type);
        if (defaultId == null) {
            return null;
        }
        return this.tariffRepo.findTariffById(defaultId.longValue());
    }

    public boolean setDefaultTariff(TariffSpecification newSpec) {
        this.tariffRepo.addSpecification(newSpec);
        Tariff tariff = new Tariff(newSpec);
        tariff.init();
        this.defaultTariff.put(newSpec.getPowerType(), tariff.getId());
        return true;
    }

    public void subscribeToTariff(Tariff tariff, CustomerInfo customer, int customerCount) {
        if (!tariff.isExpired() && !tariff.isRevoked()) {
            this.postPendingSubscriptionEvent(tariff, customer, customerCount);
            List existingSubscriptions = this.tariffSubscriptionRepo.findSubscriptionsForCustomer(customer);
            if (0 == existingSubscriptions.size()) {
                this.processPendingSubscriptions();
            }
        } else {
            log.warn((Object)("Attempt to subscribe to " + (tariff.isRevoked() ? "revoked" : "expired") + " tariff"));
        }
    }

    private synchronized void postPendingSubscriptionEvent(Tariff tariff, CustomerInfo customer, int customerCount) {
        PendingSubscription event = new PendingSubscription(tariff, customer, customerCount);
        this.pendingSubscriptionEvents.add(event);
    }

    private synchronized void processPendingSubscriptions() {
        for (PendingSubscription pending : this.pendingSubscriptionEvents) {
            TariffSubscription sub = this.tariffSubscriptionRepo.getSubscription(pending.customer, pending.tariff);
            if (pending.count > 0) {
                sub.subscribe(pending.count);
                continue;
            }
            sub.deferredUnsubscribe(-pending.count);
        }
        this.pendingSubscriptionEvents.clear();
    }

    private void processPendingVrus() {
        for (VariableRateUpdate vru : this.getVruList()) {
            Tariff tariff = this.tariffRepo.findTariffById(vru.getTariffId());
            if (tariff.addHourlyCharge(vru.getHourlyCharge(), vru.getRateId())) {
                this.success((TariffUpdate)vru);
                continue;
            }
            this.send((TariffMessage)new TariffStatus(vru.getBroker(), vru.getTariffId(), vru.getId(), TariffStatus.Status.invalidUpdate).withMessage("update: could not add hourly charge"));
        }
    }

    private synchronized void addVru(VariableRateUpdate newVru) {
        this.pendingVrus.add(newVru);
    }

    private synchronized List<VariableRateUpdate> getVruList() {
        ArrayList<VariableRateUpdate> result = new ArrayList<VariableRateUpdate>(this.pendingVrus);
        this.pendingVrus.clear();
        return result;
    }

    private void success(TariffUpdate update) {
        Broker broker = update.getBroker();
        this.send((TariffMessage)new TariffStatus(broker, update.getTariffId(), update.getId(), TariffStatus.Status.success));
    }

    private void send(TariffMessage msg) {
        if (null == msg) {
            log.debug((Object)"null outgoing message");
        } else {
            this.brokerProxyService.sendMessage(msg.getBroker(), (Object)msg);
        }
    }

    private ValidationResult validateUpdate(TariffUpdate update) {
        Broker broker = update.getBroker();
        Tariff tariff = this.tariffRepo.findTariffById(update.getTariffId());
        if (tariff == null) {
            log.error((Object)("update - no such tariff " + update.getTariffId() + ", broker " + update.getBroker().getUsername()));
            return new ValidationResult(null, new TariffStatus(broker, update.getTariffId(), update.getId(), TariffStatus.Status.noSuchTariff));
        }
        return new ValidationResult(tariff, null);
    }

    public void setDefaults() {
    }

    private class PendingSubscription {
        Tariff tariff;
        CustomerInfo customer;
        int count;

        PendingSubscription(Tariff tariff, CustomerInfo customer, int count) {
            this.tariff = tariff;
            this.customer = customer;
            this.count = count;
        }
    }

    private class ValidationResult {
        Tariff tariff;
        TariffStatus message;

        ValidationResult(Tariff tariff, TariffStatus msg) {
            this.tariff = tariff;
            this.message = msg;
        }
    }
}

