/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.accounting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.BalancingTransaction;
import org.powertac.common.BankTransaction;
import org.powertac.common.Broker;
import org.powertac.common.BrokerTransaction;
import org.powertac.common.CapacityTransaction;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.DistributionTransaction;
import org.powertac.common.MarketPosition;
import org.powertac.common.MarketTransaction;
import org.powertac.common.RandomSeed;
import org.powertac.common.Tariff;
import org.powertac.common.TariffTransaction;
import org.powertac.common.TimeService;
import org.powertac.common.Timeslot;
import org.powertac.common.TransactionFactory;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.Accounting;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.msg.BalancingControlEvent;
import org.powertac.common.msg.DistributionReport;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.util.MessageDispatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccountingService
extends TimeslotPhaseProcessor
implements Accounting,
InitializationService {
    private static Logger log = LogManager.getLogger((String)AccountingService.class.getSimpleName());
    @Autowired
    private TimeService timeService;
    @Autowired
    private TariffRepo tariffRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private BrokerRepo brokerRepo;
    @Autowired
    private BrokerProxy brokerProxyService;
    @Autowired
    private RandomSeedRepo randomSeedService;
    @Autowired
    private TransactionFactory txFactory;
    @Autowired
    private ServerConfiguration serverProps;
    private ArrayList<BrokerTransaction> pendingTransactions = new ArrayList();
    private DistributionReport distributionReport;
    private double totalConsumption;
    private double totalProduction;
    private HashMap<Timeslot, ArrayList<MarketTransaction>> pendingMarketTransactions = new HashMap();
    @ConfigurableValue(valueType="Double", description="low end of bank interest rate range")
    private double minInterest = 0.04;
    @ConfigurableValue(valueType="Double", description="high end of bank interest rate range")
    private double maxInterest = 0.12;
    @ConfigurableValue(valueType="Double", publish=true, description="override random setting of bank interest rate")
    private Double bankInterest = null;

    public String initialize(Competition competition, List<String> completedInits) {
        this.pendingTransactions.clear();
        this.pendingMarketTransactions.clear();
        super.init();
        this.bankInterest = null;
        this.serverProps.configureMe((Object)this);
        RandomSeed random = this.randomSeedService.getRandomSeed("AccountingService", 0L, "interest");
        if (this.bankInterest == null) {
            this.bankInterest = this.minInterest + random.nextDouble() * (this.maxInterest - this.minInterest);
            log.info("bank interest: " + this.bankInterest);
        }
        this.serverProps.publishConfiguration((Object)this);
        return "AccountingService";
    }

    public synchronized MarketTransaction addMarketTransaction(Broker broker, Timeslot timeslot, double mWh, double price) {
        MarketTransaction mtx = this.txFactory.makeMarketTransaction(broker, timeslot, mWh, price);
        this.pendingTransactions.add((BrokerTransaction)mtx);
        this.updateBrokerMarketPosition(mtx);
        ArrayList<Object> theList = this.pendingMarketTransactions.get(timeslot);
        if (null == theList) {
            theList = new ArrayList();
            this.pendingMarketTransactions.put(timeslot, theList);
        }
        theList.add(mtx);
        return mtx;
    }

    public synchronized TariffTransaction addTariffTransaction(TariffTransaction.Type txType, Tariff tariff, CustomerInfo customer, int customerCount, double kWh, double charge) {
        TariffTransaction ttx = this.txFactory.makeTariffTransaction(tariff.getBroker(), txType, this.tariffRepo.findSpecificationById(tariff.getSpecId()), customer, customerCount, kWh, charge);
        if (null == ttx.getTariffSpec()) {
            log.error("Null tariff spec in addTariffTx()");
        }
        this.pendingTransactions.add((BrokerTransaction)ttx);
        return ttx;
    }

    public synchronized TariffTransaction addRegulationTransaction(Tariff tariff, CustomerInfo customer, int customerCount, double kWh, double charge) {
        TariffTransaction ttx;
        TariffTransaction.Type txType = TariffTransaction.Type.CONSUME;
        if (kWh > 0.0) {
            txType = TariffTransaction.Type.PRODUCE;
        }
        if (null == (ttx = this.txFactory.makeTariffTransaction(tariff.getBroker(), txType, this.tariffRepo.findSpecificationById(tariff.getSpecId()), customer, customerCount, kWh, charge, true)).getTariffSpec()) {
            log.error("Null tariff spec in addTariffTx()");
        }
        this.pendingTransactions.add((BrokerTransaction)ttx);
        return ttx;
    }

    public synchronized DistributionTransaction addDistributionTransaction(Broker broker, int nSmall, int nLarge, double transport, double distroCharge) {
        DistributionTransaction dtx = this.txFactory.makeDistributionTransaction(broker, nSmall, nLarge, transport, distroCharge);
        this.pendingTransactions.add((BrokerTransaction)dtx);
        return dtx;
    }

    public synchronized BalancingTransaction addBalancingTransaction(Broker broker, double kWh, double charge) {
        BalancingTransaction btx = this.txFactory.makeBalancingTransaction(broker, kWh, charge);
        this.pendingTransactions.add((BrokerTransaction)btx);
        return btx;
    }

    public synchronized CapacityTransaction addCapacityTransaction(Broker broker, int peakTimeslot, double threshold, double kWh, double fee) {
        CapacityTransaction ctx = this.txFactory.makeCapacityTransaction(broker, peakTimeslot, threshold, kWh, fee);
        this.pendingTransactions.add((BrokerTransaction)ctx);
        return ctx;
    }

    public synchronized void postBalancingControl(BalancingControlEvent bce) {
        log.info("post balancing control for {}, payment={}, kWh={}, tariff={}, ts={}", (Object)bce.getBroker().getUsername(), (Object)bce.getPayment(), (Object)bce.getKwh(), (Object)bce.getTariffId(), (Object)bce.getTimeslotIndex());
        this.updateCash(bce.getBroker(), bce.getPayment());
    }

    public synchronized double getCurrentNetLoad(Broker broker) {
        double netLoad = 0.0;
        for (BrokerTransaction btx : this.pendingTransactions) {
            TariffTransaction ttx;
            if (!(btx instanceof TariffTransaction) || !(ttx = (TariffTransaction)btx).getBroker().getUsername().equals(broker.getUsername()) || ttx.getTxType() != TariffTransaction.Type.CONSUME && ttx.getTxType() != TariffTransaction.Type.PRODUCE) continue;
            netLoad += ttx.getKWh();
        }
        log.info("net load for " + broker.getUsername() + ": " + netLoad);
        return netLoad;
    }

    public Map<Broker, Map<TariffTransaction.Type, Double>> getCurrentSupplyDemandByBroker() {
        HashMap<Broker, Map<TariffTransaction.Type, Double>> result = new HashMap<Broker, Map<TariffTransaction.Type, Double>>();
        for (BrokerTransaction btx : this.pendingTransactions) {
            if (!(btx instanceof TariffTransaction)) continue;
            TariffTransaction ttx = (TariffTransaction)btx;
            Broker broker = ttx.getBroker();
            Map<TariffTransaction.Type, Double> record = result.get(broker);
            if (null == record) {
                record = new HashMap<TariffTransaction.Type, Double>();
                result.put(broker, record);
                record.put(TariffTransaction.Type.CONSUME, 0.0);
                record.put(TariffTransaction.Type.PRODUCE, 0.0);
            }
            if (ttx.getTxType() == TariffTransaction.Type.CONSUME) {
                record.put(TariffTransaction.Type.CONSUME, record.get(TariffTransaction.Type.CONSUME) + ttx.getKWh());
                continue;
            }
            if (ttx.getTxType() != TariffTransaction.Type.PRODUCE) continue;
            record.put(TariffTransaction.Type.PRODUCE, record.get(TariffTransaction.Type.PRODUCE) + ttx.getKWh());
        }
        return result;
    }

    public synchronized double getCurrentMarketPosition(Broker broker) {
        Timeslot current = this.timeslotRepo.currentTimeslot();
        log.debug("current timeslot: " + current.getSerialNumber());
        MarketPosition position = broker.findMarketPositionByTimeslot(current.getSerialNumber());
        if (position == null) {
            log.debug("null position for ts " + current.getSerialNumber());
            return 0.0;
        }
        log.info("market position for " + broker.getUsername() + ": " + position.getOverallBalance());
        return position.getOverallBalance();
    }

    public void activate(Instant time, int phaseNumber) {
        log.info("Activate: " + this.pendingTransactions.size() + " messages");
        this.totalConsumption = 0.0;
        this.totalProduction = 0.0;
        HashMap brokerMsg = new HashMap();
        for (Broker broker : this.brokerRepo.list()) {
            brokerMsg.put(broker, new ArrayList());
        }
        for (BrokerTransaction tx : this.getPendingTransactionList()) {
            if (tx.getBroker() == null) {
                log.error("tx " + tx.getClass().getName() + ":" + tx.getId() + " has null broker");
            }
            if (brokerMsg.get(tx.getBroker()) == null) {
                log.error("tx " + tx.getClass().getName() + ":" + tx.getId() + " has unknown broker " + tx.getBroker().getUsername());
            }
            ((List)brokerMsg.get(tx.getBroker())).add(tx);
            MessageDispatcher.dispatch((Object)((Object)this), (String)"processTransaction", (Object[])new Object[]{tx, brokerMsg.get(tx.getBroker())});
        }
        this.handleMarketTransactionsForTimeslot(this.timeslotRepo.currentTimeslot());
        double rate = this.bankInterest / 365.0;
        for (Broker broker : this.brokerRepo.list()) {
            if (this.timeService.getHourOfDay() == 0) {
                double brokerRate = rate;
                double cash = broker.getCashBalance();
                if (cash >= 0.0) {
                    brokerRate /= 2.0;
                }
                double interest = cash * brokerRate;
                ((List)brokerMsg.get(broker)).add(this.txFactory.makeBankTransaction(broker, interest));
                broker.updateCash(interest);
            }
            ((List)brokerMsg.get(broker)).add(this.txFactory.makeCashPosition(broker, broker.getCashBalance()));
            log.info("Broker {} balance = {}", (Object)broker.getUsername(), (Object)broker.getCashBalance());
            log.info("Sending " + ((List)brokerMsg.get(broker)).size() + " messages to " + broker.getUsername());
            this.brokerProxyService.sendMessages(broker, (List)brokerMsg.get(broker));
        }
        this.distributionReport = new DistributionReport(this.timeslotRepo.currentSerialNumber(), this.totalConsumption, this.totalProduction);
        this.brokerProxyService.broadcastMessage((Object)this.distributionReport);
    }

    private synchronized List<BrokerTransaction> getPendingTransactionList() {
        ArrayList<BrokerTransaction> result = new ArrayList<BrokerTransaction>(this.pendingTransactions);
        this.pendingTransactions.clear();
        return result;
    }

    public void processTransaction(TariffTransaction tx, ArrayList<Object> messages) {
        this.updateCash(tx.getBroker(), tx.getCharge());
        if (TariffTransaction.Type.CONSUME == tx.getTxType()) {
            this.totalConsumption -= tx.getKWh();
        } else if (TariffTransaction.Type.PRODUCE == tx.getTxType()) {
            this.totalProduction += tx.getKWh();
        }
    }

    public void processTransaction(BalancingTransaction tx, ArrayList<Object> messages) {
        this.updateCash(tx.getBroker(), tx.getCharge());
    }

    public void processTransaction(DistributionTransaction tx, ArrayList<Object> messages) {
        this.updateCash(tx.getBroker(), tx.getCharge());
    }

    public void processTransaction(CapacityTransaction tx, ArrayList<Object> messages) {
        this.updateCash(tx.getBroker(), tx.getCharge());
    }

    public void processTransaction(MarketTransaction tx, ArrayList<Object> messages) {
        MarketPosition mkt = tx.getBroker().findMarketPositionByTimeslot(tx.getTimeslotIndex());
        if (!messages.contains(mkt)) {
            messages.add(mkt);
        }
    }

    public void handleMarketTransactionsForTimeslot(Timeslot ts) {
        ArrayList<MarketTransaction> pending = this.pendingMarketTransactions.get(ts);
        if (null == pending) {
            return;
        }
        for (MarketTransaction tx : pending) {
            Broker broker = tx.getBroker();
            this.updateCash(broker, tx.getPrice() * Math.abs(tx.getMWh()));
        }
    }

    private void updateBrokerMarketPosition(MarketTransaction tx) {
        Broker broker = tx.getBroker();
        MarketPosition mkt = broker.findMarketPositionByTimeslot(tx.getTimeslotIndex());
        if (mkt == null) {
            mkt = new MarketPosition(broker, tx.getTimeslot(), tx.getMWh());
            log.debug("New MarketPosition(" + broker.getUsername() + ", " + tx.getTimeslot().getSerialNumber() + "): " + mkt.getId());
            broker.addMarketPosition(mkt, tx.getTimeslotIndex());
        } else {
            mkt.updateBalance(tx.getMWh());
        }
    }

    private void updateCash(Broker broker, double amount) {
        broker.updateCash(amount);
    }

    public void processTransaction(BankTransaction tx, ArrayList<Object> messages) {
        log.error("tx {} calls processTransaction - should not happen", (Object)tx.toString());
    }

    public synchronized List<TariffTransaction> getPendingTariffTransactions() {
        ArrayList<TariffTransaction> result = new ArrayList<TariffTransaction>();
        for (BrokerTransaction tx : this.pendingTransactions) {
            if (!(tx instanceof TariffTransaction)) continue;
            result.add((TariffTransaction)tx);
        }
        return result;
    }

    List<BrokerTransaction> getPendingTransactions() {
        return this.pendingTransactions;
    }

    public double getMinInterest() {
        return this.minInterest;
    }

    public double getMaxInterest() {
        return this.maxInterest;
    }

    public Double getBankInterest() {
        return this.bankInterest;
    }

    void setBankInterest(Double interest) {
        this.bankInterest = interest;
    }
}

