/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.tariffmarket;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.powertac.common.Broker;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.Rate;
import org.powertac.common.RegulationRate;
import org.powertac.common.Tariff;
import org.powertac.common.TariffMessage;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TariffSubscription;
import org.powertac.common.TariffTransaction;
import org.powertac.common.TimeService;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.Accounting;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.CapacityControl;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.NewTariffListener;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.msg.BalancingOrder;
import org.powertac.common.msg.EconomicControlEvent;
import org.powertac.common.msg.TariffExpire;
import org.powertac.common.msg.TariffRevoke;
import org.powertac.common.msg.TariffStatus;
import org.powertac.common.msg.TariffUpdate;
import org.powertac.common.msg.VariableRateUpdate;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.util.ListTools;
import org.powertac.util.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TariffMarketService
extends TimeslotPhaseProcessor
implements TariffMarket,
InitializationService {
    private static Logger log = LogManager.getLogger((String)TariffMarketService.class.getSimpleName());
    final Level BFAULT = Level.forName((String)"BFAULT", (int)250);
    @Autowired
    private TimeService timeService;
    @Autowired
    private Accounting accountingService;
    @Autowired
    private CapacityControl capacityControlService;
    @Autowired
    private BrokerProxy brokerProxyService;
    @Autowired
    private BrokerRepo brokerRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private TariffRepo tariffRepo;
    @Autowired
    private TariffSubscriptionRepo tariffSubscriptionRepo;
    @Autowired
    private ServerConfiguration serverProps;
    @Autowired
    private RandomSeedRepo randomSeedService;
    private ArrayList<Tariff> pendingRevokedTariffs = new ArrayList();
    private List<Tariff> revokedTariffs = null;
    private Instant lastRevokeProcess = new Instant(0L);
    @ConfigurableValue(valueType="Double", description="low end of tariff publication fee range")
    private double minPublicationFee = -100.0;
    @ConfigurableValue(valueType="Double", description="high end of tariff publication fee range")
    private double maxPublicationFee = -500.0;
    @ConfigurableValue(valueType="Double", publish=true, description="set publication fee directly to override random selection")
    private Double publicationFee = null;
    @ConfigurableValue(valueType="Double", description="low end of tariff revocation fee range")
    private double minRevocationFee = -100.0;
    @ConfigurableValue(valueType="Double", description="high end of tariff revocation fee range")
    private double maxRevocationFee = -500.0;
    @ConfigurableValue(valueType="Double", publish=true, description="Set revocation fee directly to override random selection")
    private Double revocationFee = null;
    private int publicationInterval = 6;
    private int publicationOffset = 0;
    private boolean subsequentPublication;
    private List<PendingSubscription> pendingSubscriptionEvents = new ArrayList<PendingSubscription>();
    private List<VariableRateUpdate> pendingVrus = new ArrayList<VariableRateUpdate>();
    private HashSet<Broker> disabledBrokers = new HashSet();
    private Set<NewTariffListener> registrations = new LinkedHashSet<NewTariffListener>();

    public String initialize(Competition competition, List<String> completedInits) {
        int index = completedInits.indexOf("AccountingService");
        if (index == -1) {
            return null;
        }
        for (Class clazz : Arrays.asList(TariffSpecification.class, TariffExpire.class, TariffRevoke.class, VariableRateUpdate.class, EconomicControlEvent.class, BalancingOrder.class)) {
            this.brokerProxyService.registerBrokerMessageListener((Object)this, clazz);
        }
        this.subsequentPublication = false;
        this.registrations.clear();
        this.publicationFee = null;
        this.revocationFee = null;
        super.init();
        this.pendingSubscriptionEvents.clear();
        this.pendingRevokedTariffs.clear();
        this.pendingVrus.clear();
        this.disabledBrokers.clear();
        this.revokedTariffs = null;
        this.lastRevokeProcess = new Instant(0L);
        this.serverProps.configureMe((Object)this);
        List listeners = SpringApplicationContext.listBeansOfType(NewTariffListener.class);
        for (NewTariffListener listener : listeners) {
            this.registerNewTariffListener(listener);
        }
        RandomSeed randomSeed = this.randomSeedService.getRandomSeed("TariffMarket", 0L, "fees");
        if (this.publicationFee == null) {
            this.publicationFee = this.minPublicationFee + randomSeed.nextDouble() * (this.maxPublicationFee - this.minPublicationFee);
            log.info("set publication fee: " + this.publicationFee);
        }
        if (this.revocationFee == null) {
            this.revocationFee = this.minRevocationFee + randomSeed.nextDouble() * (this.maxRevocationFee - this.minRevocationFee);
            log.info("set revocation fee: " + this.revocationFee);
        }
        this.serverProps.publishConfiguration((Object)this);
        return "TariffMarket";
    }

    public double getMinPublicationFee() {
        return this.minPublicationFee;
    }

    public double getMaxPublicationFee() {
        return this.maxPublicationFee;
    }

    public Double getPublicationFee() {
        return this.publicationFee;
    }

    public double getMinRevocationFee() {
        return this.minRevocationFee;
    }

    public double getMaxRevocationFee() {
        return this.maxRevocationFee;
    }

    public Double getRevocationFee() {
        return this.revocationFee;
    }

    public int getPublicationInterval() {
        return this.publicationInterval;
    }

    @ConfigurableValue(valueType="Integer", description="Number of timeslots between tariff publication events. Must be at most 24.")
    public void setPublicationInterval(int interval) {
        if (interval > 24) {
            log.error("tariff publication interval " + interval + " > 24 hr");
            interval = 24;
        }
        this.publicationInterval = interval;
    }

    public int getPublicationOffset() {
        return this.publicationOffset;
    }

    @ConfigurableValue(valueType="Integer", description="Number of timeslots from the first timeslot to delay the first publication event. It does not work well to make this zero, because brokers do not have an opportunity to post tariffs in timeslot 0.")
    public void setPublicationOffset(int offset) {
        if (offset >= this.publicationInterval) {
            log.error("tariff publication offset " + this.publicationOffset + " >= publication interval " + offset);
        } else {
            this.publicationOffset = offset;
        }
    }

    List<NewTariffListener> getRegistrations() {
        return new ArrayList<NewTariffListener>(this.registrations);
    }

    public void handleMessage(TariffSpecification spec) {
        if (null != this.tariffRepo.findSpecificationById(spec.getId()) && !this.tariffRepo.isRemoved(spec.getId())) {
            log.log(this.BFAULT, "duplicate tariff spec from " + spec.getBroker().getUsername() + ", id = " + spec.getId());
            this.send((TariffMessage)new TariffStatus(spec.getBroker(), spec.getId(), spec.getId(), TariffStatus.Status.invalidTariff).withMessage("duplicate tariff spec " + spec.getId()));
            return;
        }
        if (null == spec.getRates()) {
            log.log(this.BFAULT, "no rates given for spec " + spec.getId());
            this.send((TariffMessage)new TariffStatus(spec.getBroker(), spec.getId(), spec.getId(), TariffStatus.Status.invalidTariff).withMessage("missing Rates"));
            return;
        }
        if (!spec.isValid()) {
            log.log(this.BFAULT, "invalid spec " + spec.getId());
            this.send((TariffMessage)new TariffStatus(spec.getBroker(), spec.getId(), spec.getId(), TariffStatus.Status.invalidTariff).withMessage("spec fails validity test"));
            return;
        }
        if (null != spec.getSupersedes()) {
            for (Long supersede : spec.getSupersedes()) {
                TariffSpecification other = this.tariffRepo.findSpecificationById(supersede.longValue());
                if (null == other) {
                    log.log(this.BFAULT, "attempt to supersede non-existent tariff " + supersede);
                    this.send((TariffMessage)new TariffStatus(spec.getBroker(), spec.getId(), spec.getId(), TariffStatus.Status.invalidTariff).withMessage("non-existent supersede " + supersede));
                    return;
                }
                if (spec.getBroker() == other.getBroker()) continue;
                log.log(this.BFAULT, "attempt by " + spec.getBroker().getUsername() + " to supersede tariff of " + other.getBroker().getUsername());
                this.send((TariffMessage)new TariffStatus(spec.getBroker(), spec.getId(), spec.getId(), TariffStatus.Status.invalidTariff).withMessage("invalid supersede " + supersede));
                return;
            }
        }
        for (Rate rate : spec.getRates()) {
            if (rate.getDailyBegin() < 24 && rate.getDailyEnd() < 24 && rate.getWeeklyBegin() != 0 && rate.getWeeklyBegin() <= 7 && rate.getWeeklyEnd() != 0 && rate.getWeeklyEnd() <= 7) continue;
            log.log(this.BFAULT, "invalid rate for spec " + spec.getId());
            this.send((TariffMessage)new TariffStatus(spec.getBroker(), spec.getId(), spec.getId(), TariffStatus.Status.invalidTariff).withMessage("spec has invalid Rate"));
            return;
        }
        this.tariffRepo.addSpecification(spec);
        Tariff tariff = new Tariff(spec);
        if (!tariff.init()) {
            log.log(this.BFAULT, "incomplete coverage in multi-rate tariff " + spec.getId());
            this.tariffRepo.removeTariff(tariff);
            this.send((TariffMessage)new TariffStatus(spec.getBroker(), spec.getId(), spec.getId(), TariffStatus.Status.invalidTariff).withMessage("incomplete coverage in multi-rate tariff"));
            return;
        }
        for (RegulationRate regRate : spec.getRegulationRates()) {
            BalancingOrder bo;
            if (!spec.getPowerType().isInterruptible() && !spec.getPowerType().isStorage()) continue;
            if (regRate.getUpRegulationPayment() != 0.0) {
                bo = new BalancingOrder(spec.getBroker(), spec, spec.getPowerType().isStorage() ? 2.0 : 1.0, regRate.getUpRegulationPayment());
                this.tariffRepo.addBalancingOrder(bo);
            }
            if (regRate.getDownRegulationPayment() == 0.0) continue;
            bo = new BalancingOrder(spec.getBroker(), spec, -1.0, regRate.getDownRegulationPayment());
            this.tariffRepo.addBalancingOrder(bo);
        }
        log.info("new tariff " + spec.getId());
        this.accountingService.addTariffTransaction(TariffTransaction.Type.PUBLISH, tariff, null, 0, 0.0, this.publicationFee.doubleValue());
        this.send((TariffMessage)new TariffStatus(spec.getBroker(), spec.getId(), spec.getId(), TariffStatus.Status.success));
    }

    public void handleMessage(TariffExpire update) {
        ValidationResult result = this.validateUpdate((TariffUpdate)update);
        if (result.tariff == null) {
            this.send((TariffMessage)result.message);
        } else {
            Instant newExp = update.getNewExpiration();
            if (newExp != null && newExp.isBefore((ReadableInstant)this.timeService.getCurrentTime())) {
                log.log(this.BFAULT, "attempt to set expiration for tariff " + result.tariff.getId() + " in the past:" + newExp.toString());
                this.send((TariffMessage)new TariffStatus(update.getBroker(), update.getTariffId(), update.getId(), TariffStatus.Status.invalidUpdate).withMessage("attempt to set expiration in the past"));
            } else {
                result.tariff.setExpiration(newExp);
                log.info("Tariff " + update.getTariffId() + "now expires at " + new DateTime((Object)result.tariff.getExpiration(), DateTimeZone.UTC).toString());
                this.success((TariffUpdate)update);
            }
        }
    }

    public void handleMessage(TariffRevoke update) {
        ValidationResult result = this.validateUpdate((TariffUpdate)update);
        if (result.tariff == null) {
            this.send((TariffMessage)result.message);
            return;
        }
        this.addPendingRevoke(result.tariff);
        this.success((TariffUpdate)update);
    }

    public void handleMessage(VariableRateUpdate update) {
        ValidationResult result = this.validateUpdate((TariffUpdate)update);
        if (result.tariff == null) {
            this.send((TariffMessage)result.message);
            return;
        }
        Rate rate = this.tariffRepo.findRateById(update.getRateId());
        if (rate == null) {
            this.send((TariffMessage)new TariffStatus(update.getBroker(), update.getTariffId(), update.getId(), TariffStatus.Status.invalidUpdate).withMessage("Non-existent rate in VRU"));
            return;
        }
        if (!result.tariff.getTariffSpecification().getRates().contains(rate)) {
            this.send((TariffMessage)new TariffStatus(update.getBroker(), update.getTariffId(), update.getId(), TariffStatus.Status.invalidUpdate).withMessage("Rate not associated with tariff in VRU"));
            return;
        }
        if (!update.isValid(rate)) {
            this.send((TariffMessage)new TariffStatus(update.getBroker(), update.getTariffId(), update.getId(), TariffStatus.Status.invalidUpdate).withMessage("Invalid charge in VRU"));
            return;
        }
        this.addVru(update);
    }

    public synchronized void handleMessage(EconomicControlEvent msg) {
        ValidationResult result = this.validateUpdate((TariffUpdate)msg);
        if (result.tariff == null) {
            this.send((TariffMessage)result.message);
            return;
        }
        int currentTimeslot = this.timeslotRepo.currentTimeslot().getSerialNumber();
        if (currentTimeslot > msg.getTimeslotIndex()) {
            log.log(this.BFAULT, "Curtailment requested in ts " + currentTimeslot + " for past timeslot " + msg.getTimeslotIndex());
            this.send((TariffMessage)new TariffStatus(msg.getBroker(), msg.getTariffId(), msg.getId(), TariffStatus.Status.invalidUpdate).withMessage("control: specified timeslot in the past"));
            return;
        }
        this.capacityControlService.postEconomicControl(msg);
    }

    public synchronized void handleMessage(BalancingOrder msg) {
        ValidationResult result = this.validateUpdate((TariffUpdate)msg);
        if (result.tariff == null) {
            this.send((TariffMessage)result.message);
            return;
        }
        if (result.tariff.hasRegulationRate()) {
            result.message.withMessage("Cannot use BO with RegulationRate").setStatus(TariffStatus.Status.unsupported);
            this.send((TariffMessage)result.message);
            return;
        }
        boolean curtailmentAllowed = false;
        for (Rate rate : result.tariff.getTariffSpecification().getRates()) {
            if (!(rate.getMaxCurtailment() > 0.0)) continue;
            curtailmentAllowed = true;
            break;
        }
        if (!curtailmentAllowed) {
            result.message.withMessage("Cannot use BO without curtailment").setStatus(TariffStatus.Status.unsupported);
            this.send((TariffMessage)result.message);
            return;
        }
        if (msg.getExerciseRatio() <= 0.0 || msg.getExerciseRatio() > 1.0) {
            result.message.withMessage("Exercise ratio " + msg.getExerciseRatio() + " out of range").setStatus(TariffStatus.Status.unsupported);
            this.send((TariffMessage)result.message);
            return;
        }
        this.tariffRepo.addBalancingOrder(msg);
    }

    private synchronized void addPendingRevoke(Tariff tariff) {
        this.pendingRevokedTariffs.add(tariff);
    }

    private synchronized List<Tariff> getPendingRevokes() {
        Instant now = this.timeService.getCurrentTime();
        if (now.isAfter((ReadableInstant)this.lastRevokeProcess)) {
            this.lastRevokeProcess = now;
            ArrayList<Tariff> result = new ArrayList<Tariff>(this.pendingRevokedTariffs);
            this.pendingRevokedTariffs.clear();
            return result;
        }
        return null;
    }

    public void processRevokedTariffs() {
    }

    private void revokeTariffsForDisabledBrokers() {
        for (Broker broker : this.brokerRepo.findDisabledBrokers()) {
            if (this.disabledBrokers.contains(broker)) continue;
            this.disabledBrokers.add(broker);
            for (Tariff tariff : this.tariffRepo.findTariffsByBroker(broker)) {
                if (Tariff.State.KILLED == tariff.getState()) continue;
                log.info("Revoking tariff " + tariff.getId() + " from disabled broker " + broker.getUsername());
                this.addPendingRevoke(tariff);
            }
        }
    }

    private void updateRevokedTariffs() {
        List<Tariff> pending = this.getPendingRevokes();
        if (pending == null) {
            return;
        }
        this.revokedTariffs = pending;
        for (Tariff tariff : pending) {
            tariff.setState(Tariff.State.KILLED);
            log.info("Revoke tariff " + tariff.getId());
            TariffRevoke msg = new TariffRevoke(tariff.getBroker(), tariff.getTariffSpecification());
            this.brokerProxyService.broadcastMessage((Object)msg);
            List activeSubscriptions = ListTools.filter((Collection)this.tariffSubscriptionRepo.findSubscriptionsForTariff(tariff), (Predicate)new Predicate<TariffSubscription>(){

                public boolean apply(TariffSubscription sub) {
                    return sub.getCustomersCommitted() > 0;
                }
            });
            if (activeSubscriptions.size() <= 0) continue;
            log.info("Revoked tariff " + tariff.getId() + " has " + activeSubscriptions.size() + " active subscriptions");
            this.accountingService.addTariffTransaction(TariffTransaction.Type.REVOKE, tariff, null, 0, 0.0, this.revocationFee.doubleValue());
        }
    }

    void removeRevokedTariffs() {
        if (null == this.revokedTariffs) {
            return;
        }
        for (Tariff tariff : this.revokedTariffs) {
            this.tariffSubscriptionRepo.removeSubscriptionsForTariff(tariff);
            this.tariffRepo.removeTariff(tariff);
        }
        this.revokedTariffs = null;
    }

    public void registerNewTariffListener(NewTariffListener listener) {
        this.registrations.add(listener);
    }

    public void activate(Instant time, int phase) {
        log.info("Activate");
        this.processPendingVrus();
        long msec = this.timeService.getCurrentTime().getMillis();
        if (!this.subsequentPublication || msec / 3600000L % (long)this.publicationInterval == (long)this.publicationOffset) {
            this.revokeTariffsForDisabledBrokers();
            this.updateRevokedTariffs();
            this.publishTariffs();
            this.processPendingSubscriptions();
            this.subsequentPublication = true;
        }
    }

    private void publishTariffs() {
        List publishedTariffs = this.tariffRepo.findTariffsByState(Tariff.State.PENDING);
        log.info("publishing " + publishedTariffs.size() + " new tariffs");
        for (Tariff tariff : publishedTariffs) {
            tariff.setState(Tariff.State.OFFERED);
        }
        ArrayList<TariffSpecification> publishedTariffSpecs = new ArrayList<TariffSpecification>();
        for (Tariff tariff : publishedTariffs) {
            TariffSpecification spec = tariff.getTariffSpecification();
            publishedTariffSpecs.add(spec);
            log.info("publishing spec " + spec.getId() + " broker: " + spec.getBroker().getUsername() + ", exp: " + spec.getExpiration());
        }
        for (NewTariffListener listener : this.registrations) {
            listener.publishNewTariffs(publishedTariffs);
        }
        this.brokerProxyService.broadcastMessages(publishedTariffSpecs);
    }

    public List<Tariff> getActiveTariffList(PowerType type) {
        return this.tariffRepo.findActiveTariffs(type);
    }

    public Tariff getDefaultTariff(PowerType type) {
        return this.tariffRepo.getDefaultTariff(type);
    }

    public boolean setDefaultTariff(TariffSpecification newSpec) {
        this.tariffRepo.setDefaultTariff(newSpec);
        return true;
    }

    public void subscribeToTariff(Tariff tariff, CustomerInfo customer, int customerCount) {
        if (customerCount < 0 || !tariff.isExpired() && !tariff.isRevoked()) {
            this.postPendingSubscriptionEvent(tariff, customer, customerCount);
            List existingSubscriptions = this.tariffSubscriptionRepo.findSubscriptionsForCustomer(customer);
            if (0 == existingSubscriptions.size()) {
                this.processPendingSubscriptions();
            }
        } else {
            log.warn("Attempt to subscribe to " + (tariff.isRevoked() ? "revoked" : "expired") + " tariff");
        }
    }

    private synchronized void postPendingSubscriptionEvent(Tariff tariff, CustomerInfo customer, int customerCount) {
        PendingSubscription event = new PendingSubscription(tariff, customer, customerCount);
        this.pendingSubscriptionEvents.add(event);
    }

    private synchronized void processPendingSubscriptions() {
        for (PendingSubscription pending : this.pendingSubscriptionEvents) {
            TariffSubscription sub = this.tariffSubscriptionRepo.getSubscription(pending.customer, pending.tariff);
            if (pending.count > 0) {
                sub.subscribe(pending.count);
                continue;
            }
            if (pending.count >= 0) continue;
            sub.deferredUnsubscribe(-pending.count);
        }
        this.pendingSubscriptionEvents.clear();
    }

    private void processPendingVrus() {
        for (VariableRateUpdate vru : this.getVruList()) {
            Tariff tariff = this.tariffRepo.findTariffById(vru.getTariffId());
            if (tariff.addHourlyCharge(vru.getHourlyCharge(), vru.getRateId())) {
                this.success((TariffUpdate)vru);
                continue;
            }
            this.send((TariffMessage)new TariffStatus(vru.getBroker(), vru.getTariffId(), vru.getId(), TariffStatus.Status.invalidUpdate).withMessage("update: could not add hourly charge"));
        }
    }

    private synchronized void addVru(VariableRateUpdate newVru) {
        this.pendingVrus.add(newVru);
    }

    private synchronized List<VariableRateUpdate> getVruList() {
        ArrayList<VariableRateUpdate> result = new ArrayList<VariableRateUpdate>(this.pendingVrus);
        this.pendingVrus.clear();
        return result;
    }

    private void success(TariffUpdate update) {
        Broker broker = update.getBroker();
        this.send((TariffMessage)new TariffStatus(broker, update.getTariffId(), update.getId(), TariffStatus.Status.success));
    }

    private void send(TariffMessage msg) {
        if (null == msg) {
            log.debug("null outgoing message");
        } else {
            this.brokerProxyService.sendMessage(msg.getBroker(), (Object)msg);
        }
    }

    private ValidationResult validateUpdate(TariffUpdate update) {
        Broker broker = update.getBroker();
        Tariff tariff = this.tariffRepo.findTariffById(update.getTariffId());
        if (tariff == null) {
            log.log(this.BFAULT, "update - no such tariff " + update.getTariffId() + ", broker " + update.getBroker().getUsername());
            return new ValidationResult(null, new TariffStatus(broker, update.getTariffId(), update.getId(), TariffStatus.Status.noSuchTariff));
        }
        if (broker != tariff.getBroker()) {
            log.log(this.BFAULT, "update - attempt by " + broker.getUsername() + " to revoke " + tariff.getBroker() + "'s tariff");
            return new ValidationResult(null, new TariffStatus(broker, update.getTariffId(), update.getId(), TariffStatus.Status.invalidTariff));
        }
        return new ValidationResult(tariff, new TariffStatus(broker, update.getTariffId(), update.getId(), TariffStatus.Status.success));
    }

    private class PendingSubscription {
        Tariff tariff;
        CustomerInfo customer;
        int count;

        PendingSubscription(Tariff tariff, CustomerInfo customer, int count) {
            this.tariff = tariff;
            this.customer = customer;
            this.count = count;
        }
    }

    private class ValidationResult {
        Tariff tariff;
        TariffStatus message;

        ValidationResult(Tariff tariff, TariffStatus msg) {
            this.tariff = tariff;
            this.message = msg;
        }
    }
}

