/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.Broker;
import org.powertac.common.Rate;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSpecification;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.msg.BalancingOrder;
import org.powertac.common.repo.DomainRepo;
import org.springframework.stereotype.Service;

@Service
public class TariffRepo
implements DomainRepo {
    private static Logger log = LogManager.getLogger((String)TariffRepo.class.getName());
    private HashMap<Long, TariffSpecification> specs = new HashMap();
    private HashSet<Long> deletedTariffs = new HashSet();
    private HashMap<PowerType, Tariff> defaultTariffs = new HashMap();
    private HashMap<Long, Tariff> tariffs = new HashMap();
    private HashMap<Long, Rate> rates = new HashMap();
    private TreeMap<Long, BoPair> balancingOrders = new TreeMap();
    private TreeMap<String, LinkedList<Tariff>> brokerTariffs = new TreeMap();

    public synchronized void addSpecification(TariffSpecification spec) {
        if (this.isRemoved(spec.getId()) || null != this.specs.get(spec.getId())) {
            log.error("Attempt to insert tariff spec with duplicate ID " + spec.getId());
            return;
        }
        this.specs.put(spec.getId(), spec);
        for (Rate r : spec.getRates()) {
            this.rates.put(r.getId(), r);
        }
    }

    public void removeSpecification(long id) {
        this.specs.remove(id);
    }

    public void setDefaultTariff(TariffSpecification newSpec) {
        this.addSpecification(newSpec);
        Tariff tariff = new Tariff(newSpec);
        tariff.init();
        this.defaultTariffs.put(newSpec.getPowerType(), tariff);
    }

    public Tariff getDefaultTariff(PowerType type) {
        Tariff result = this.defaultTariffs.get(type);
        if (null == result) {
            result = this.defaultTariffs.get(type.getGenericType());
        }
        if (null == result) {
            log.error("Cannot find default tariff for PowerType " + type);
        }
        return result;
    }

    public synchronized TariffSpecification findSpecificationById(long id) {
        return this.specs.get(id);
    }

    public synchronized List<TariffSpecification> findTariffSpecificationsByBroker(Broker broker) {
        ArrayList<TariffSpecification> result = new ArrayList<TariffSpecification>();
        for (TariffSpecification spec : this.specs.values()) {
            if (spec.getBroker() != broker) continue;
            result.add(spec);
        }
        return result;
    }

    public synchronized List<TariffSpecification> findTariffSpecificationsByPowerType(PowerType type) {
        ArrayList<TariffSpecification> result = new ArrayList<TariffSpecification>();
        for (TariffSpecification spec : this.specs.values()) {
            if (!spec.getPowerType().canUse(type)) continue;
            result.add(spec);
        }
        return result;
    }

    public synchronized List<TariffSpecification> findAllTariffSpecifications() {
        return new ArrayList<TariffSpecification>(this.specs.values());
    }

    public synchronized void addTariff(Tariff tariff) {
        if (this.isRemoved(tariff.getId()) || null != this.tariffs.get(tariff.getId())) {
            log.error("Attempt to insert tariff with duplicate ID " + tariff.getId());
            return;
        }
        this.tariffs.put(tariff.getId(), tariff);
        LinkedList<Tariff> tariffList = this.brokerTariffs.get(tariff.getBroker().getUsername());
        if (null == tariffList) {
            tariffList = new LinkedList();
            this.brokerTariffs.put(tariff.getBroker().getUsername(), tariffList);
        }
        tariffList.push(tariff);
    }

    public synchronized Tariff findTariffById(long id) {
        return this.tariffs.get(id);
    }

    public synchronized List<Tariff> findAllTariffs() {
        return new ArrayList<Tariff>(this.tariffs.values());
    }

    public synchronized List<Tariff> findTariffsByState(Tariff.State state) {
        ArrayList<Tariff> result = new ArrayList<Tariff>();
        for (Tariff tariff : this.tariffs.values()) {
            if (state != tariff.getState()) continue;
            result.add(tariff);
        }
        return result;
    }

    public synchronized List<Tariff> findActiveTariffs(PowerType type) {
        ArrayList<Tariff> result = new ArrayList<Tariff>();
        for (Tariff tariff : this.tariffs.values()) {
            if (tariff.getPowerType() != type || !tariff.isSubscribable()) continue;
            result.add(tariff);
        }
        return result;
    }

    public synchronized List<Tariff> findAllActiveTariffs(PowerType type) {
        ArrayList<Tariff> result = new ArrayList<Tariff>();
        for (Tariff tariff : this.tariffs.values()) {
            if (!type.canUse(tariff.getPowerType()) || !tariff.isSubscribable()) continue;
            result.add(tariff);
        }
        return result;
    }

    public synchronized List<Tariff> findRecentActiveTariffs(int n, PowerType type) {
        ArrayList<Tariff> result = new ArrayList<Tariff>();
        HashMap<PowerType, Integer> ptCounter = new HashMap<PowerType, Integer>();
        for (String userName : this.brokerTariffs.keySet()) {
            ptCounter.clear();
            for (Tariff tariff : this.brokerTariffs.get(userName)) {
                PowerType pt = tariff.getPowerType();
                if (!tariff.isSubscribable() || !type.canUse(pt)) continue;
                Integer count = (Integer)ptCounter.get(pt);
                if (null == count) {
                    count = 0;
                }
                if (count >= n) continue;
                result.add(tariff);
                ptCounter.put(pt, count + 1);
            }
        }
        return result;
    }

    public List<Tariff> findTariffsByBroker(Broker broker) {
        List result = this.brokerTariffs.get(broker.getUsername());
        if (null == result) {
            return new LinkedList<Tariff>();
        }
        return result;
    }

    public synchronized void removeTariff(Tariff tariff) {
        this.tariffs.remove(tariff.getId());
        this.deletedTariffs.add(tariff.getId());
        this.removeSpecification(tariff.getId());
    }

    public synchronized void deleteTariff(Tariff tariff) {
        this.tariffs.remove(tariff.getId());
        List bt = this.brokerTariffs.get(tariff.getBroker().getUsername());
        bt.remove(tariff);
        this.removeSpecification(tariff.getId());
    }

    public synchronized boolean isRemoved(long tariffId) {
        return this.deletedTariffs.contains(tariffId);
    }

    public synchronized Rate findRateById(long id) {
        return this.rates.get(id);
    }

    public synchronized void addBalancingOrder(BalancingOrder order) {
        long tariffId = order.getTariffId();
        if (null != this.specs.get(tariffId)) {
            BoPair pair = this.balancingOrders.get(tariffId);
            if (null == pair) {
                pair = new BoPair();
                this.balancingOrders.put(tariffId, pair);
            }
            pair.add(order);
        }
    }

    public synchronized Collection<BalancingOrder> getBalancingOrders() {
        ArrayList<BalancingOrder> result = new ArrayList<BalancingOrder>();
        for (BoPair pair : this.balancingOrders.values()) {
            for (BalancingOrder item : pair.getOrders()) {
                result.add(item);
            }
        }
        return result;
    }

    @Override
    public synchronized void recycle() {
        this.specs.clear();
        this.tariffs.clear();
        this.defaultTariffs.clear();
        this.deletedTariffs.clear();
        this.rates.clear();
        this.balancingOrders.clear();
        this.brokerTariffs.clear();
    }

    class BoPair {
        private BalancingOrder upOrder;
        private BalancingOrder downOrder;

        BoPair() {
        }

        BalancingOrder getUpOrder() {
            return this.upOrder;
        }

        void setUpOrder(BalancingOrder order) {
            this.upOrder = order;
        }

        BalancingOrder getDownOrder() {
            return this.downOrder;
        }

        void setDownOrder(BalancingOrder order) {
            this.downOrder = order;
        }

        void add(BalancingOrder order) {
            if (order.getExerciseRatio() >= 0.0) {
                this.upOrder = order;
            } else {
                this.downOrder = order;
            }
        }

        List<BalancingOrder> getOrders() {
            ArrayList<BalancingOrder> result = new ArrayList<BalancingOrder>();
            if (null != this.upOrder) {
                result.add(this.upOrder);
            }
            if (null != this.downOrder) {
                result.add(this.downOrder);
            }
            return result;
        }
    }
}

