/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker.core;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.config.Configurator;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class BrokerPropertiesService
implements ApplicationContextAware {
    private static Logger log = LogManager.getLogger(BrokerPropertiesService.class);
    private ApplicationContext context;
    private CompositeConfiguration config;
    private Configurator configurator;
    private boolean initialized = false;
    private String[] excludedPaths = new String[]{".*/test-classes/.*", ".*/log4j.properties"};

    public BrokerPropertiesService() {
        this.recycle();
    }

    void recycle() {
        this.config = new CompositeConfiguration();
        this.configurator = new Configurator();
        this.initialized = false;
    }

    void lazyInit() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        log.debug("lazyInit");
        try {
            File defaultProps = new File("broker.properties");
            log.info("adding " + defaultProps.getName());
            this.config.addConfiguration((Configuration)new PropertiesConfiguration(defaultProps));
        }
        catch (Exception e1) {
            log.warn("broker.properties not found: " + e1.toString());
        }
        try {
            Resource[] propResources;
            Resource[] xmlResources;
            Resource[] resourceArray = xmlResources = this.context.getResources("classpath*:config/properties.xml");
            int n = xmlResources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource xml = resourceArray[n2];
                if (this.validXmlResource(xml)) {
                    log.info("loading config from " + xml.getURI());
                    XMLConfiguration xconfig = new XMLConfiguration();
                    xconfig.load(xml.getInputStream());
                    this.config.addConfiguration((Configuration)xconfig);
                }
                ++n2;
            }
            Resource[] resourceArray2 = propResources = this.context.getResources("classpath*:config/*.properties");
            int n3 = propResources.length;
            n = 0;
            while (n < n3) {
                Resource prop = resourceArray2[n];
                if (this.validPropResource(prop)) {
                    if (prop == null) {
                        log.error("Null resource");
                    }
                    log.info("loading config from " + prop.getURI());
                    PropertiesConfiguration pconfig = new PropertiesConfiguration();
                    pconfig.load(prop.getInputStream());
                    this.config.addConfiguration((Configuration)pconfig);
                }
                ++n;
            }
        }
        catch (ConfigurationException e) {
            log.error("Problem loading configuration: " + e.toString());
        }
        catch (Exception e) {
            log.error("Error loading configuration: " + e.toString());
        }
        this.configurator.setConfiguration((Configuration)this.config);
    }

    public void setUserConfig(File userConfig) {
        try {
            PropertiesConfiguration pconfig = new PropertiesConfiguration();
            pconfig.load(userConfig);
            this.config.addConfiguration((Configuration)pconfig);
            log.debug("setUserConfig " + userConfig.getName());
        }
        catch (ConfigurationException e) {
            log.error("Config error loading " + userConfig + ": " + e.toString());
        }
        this.lazyInit();
    }

    public void configureMe(Object target) {
        this.lazyInit();
        this.configurator.configureSingleton(target);
    }

    public Collection<?> configureInstances(Class<?> target) {
        this.lazyInit();
        return this.configurator.configureInstances(target);
    }

    public String getProperty(String name) {
        this.lazyInit();
        return this.config.getString(name);
    }

    public String getProperty(String name, String defaultValue) {
        this.lazyInit();
        return this.config.getString(name, defaultValue);
    }

    public Integer getIntegerProperty(String name, Integer defaultValue) {
        this.lazyInit();
        return this.config.getInteger(name, defaultValue);
    }

    public Double getDoubleProperty(String name, Double defaultValue) {
        this.lazyInit();
        return this.config.getDouble(name, defaultValue);
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setProperty(String key, Object value) {
        this.lazyInit();
        this.config.setProperty(key, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validXmlResource(Resource xml) {
        try {
            log.info("Validating resource " + xml.getURI());
            String path = xml.getURI().toString();
            String[] stringArray = this.excludedPaths;
            int n = this.excludedPaths.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                String regex = stringArray[n2];
                if (path.matches(regex)) {
                    return false;
                }
                if (!xml.exists()) {
                    log.warn("Resource " + xml.getURI() + " does not exist");
                    return false;
                }
                if (!xml.isReadable()) {
                    log.warn("Resource " + xml.getURI() + " is not readable");
                    return false;
                }
                ++n2;
            }
        }
        catch (IOException e) {
            log.error("Should not happen: " + e.toString());
            return false;
        }
        catch (Exception e) {
            log.error("Validation error " + e.toString());
            e.printStackTrace();
            return false;
        }
    }

    private boolean validPropResource(Resource prop) {
        return this.validXmlResource(prop);
    }

    Configuration getConfig() {
        return this.config;
    }
}

