/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.TimeService;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.DomainRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimeslotRepo
implements DomainRepo {
    private static Logger log = LogManager.getLogger((String)TimeslotRepo.class.getName());
    private ArrayList<Timeslot> indexedTimeslots = new ArrayList();
    @Autowired
    private TimeService timeService;

    public Timeslot makeTimeslot(Instant startTime) {
        Timeslot result;
        long duration = Competition.currentCompetition().getTimeslotDuration();
        Instant base = Competition.currentCompetition().getSimulationBaseTime();
        int index = (int)((startTime.getMillis() - base.getMillis()) / duration);
        if (index < 0) {
            log.error("makeTimeslot(" + startTime.toString() + "): index=" + index + ", base=" + base);
        }
        Instant realStart = this.getTimeForIndex(index);
        if (index >= this.indexedTimeslots.size()) {
            result = new Timeslot(index, realStart);
            this.add(result);
        } else {
            result = this.indexedTimeslots.get(index);
        }
        return result;
    }

    public Timeslot currentTimeslot() {
        return this.findByInstant(this.timeService.getCurrentTime());
    }

    public int currentSerialNumber() {
        return this.currentTimeslot().getSerialNumber();
    }

    public Timeslot findBySerialNumber(int serialNumber) {
        return this.makeTimeslot(this.getTimeForIndex(serialNumber));
    }

    public Timeslot findOrCreateBySerialNumber(int serialNumber) {
        return this.findBySerialNumber(serialNumber);
    }

    public void createInitialTimeslots() {
        this.findOrCreateBySerialNumber(this.getTimeslotIndex(this.timeService.getCurrentTime()));
    }

    public Timeslot findByInstant(Instant time) {
        log.debug("find " + time.toString());
        int index = this.getTimeslotIndex(time);
        return this.findBySerialNumber(index);
    }

    public int getTimeslotIndex(Instant time) {
        long offset = time.getMillis() - Competition.currentCompetition().getSimulationBaseTime().getMillis();
        long duration = Competition.currentCompetition().getTimeslotDuration();
        return (int)(offset / duration);
    }

    public Timeslot getNext(Timeslot slot) {
        return this.findBySerialNumber(slot.getSerialNumber() + 1);
    }

    public List<Timeslot> enabledTimeslots() {
        int firstIndex = this.currentTimeslot().getSerialNumber() + Competition.currentCompetition().getDeactivateTimeslotsAhead();
        ArrayList<Timeslot> result = new ArrayList<Timeslot>(30);
        for (int index = 0; index < Competition.currentCompetition().getTimeslotsOpen(); ++index) {
            result.add(this.findOrCreateBySerialNumber(firstIndex + index));
        }
        return result;
    }

    public boolean isTimeslotEnabled(Timeslot ts) {
        return this.isTimeslotEnabled(ts.getSerialNumber());
    }

    public boolean isTimeslotEnabled(int index) {
        int firstIndex = this.currentTimeslot().getSerialNumber() + Competition.currentCompetition().getDeactivateTimeslotsAhead();
        int lastIndex = firstIndex + Competition.currentCompetition().getTimeslotsOpen();
        return index >= firstIndex && index < lastIndex;
    }

    public int count() {
        return this.indexedTimeslots.size();
    }

    public void add(Timeslot timeslot) {
        int sn = timeslot.getSerialNumber();
        if (this.indexedTimeslots.size() > sn && this.indexedTimeslots.get(sn) != timeslot) {
            log.error("timeslot sn " + sn + " already exists");
        }
        for (int index = this.indexedTimeslots.size(); index < sn; ++index) {
            this.indexedTimeslots.add(new Timeslot(index, this.getTimeForIndex(index)));
        }
        this.indexedTimeslots.add(timeslot);
    }

    public Instant getTimeForIndex(int index) {
        Competition comp = Competition.currentCompetition();
        return new Instant(comp.getSimulationBaseTime().getMillis() + (long)index * comp.getTimeslotDuration());
    }

    public DateTime getDateTimeForIndex(int index) {
        Competition comp = Competition.currentCompetition();
        return new DateTime(comp.getSimulationBaseTime().getMillis() + (long)index * comp.getTimeslotDuration(), DateTimeZone.UTC);
    }

    @Override
    public void recycle() {
        log.debug("recycle");
        this.indexedTimeslots.clear();
    }
}

