/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker.core;

import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.XMLMessageConverter;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.samplebroker.core.BrokerPropertiesService;
import org.powertac.samplebroker.core.MessageDispatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BrokerMessageReceiver
implements MessageListener {
    private static Logger log = LogManager.getLogger(BrokerMessageReceiver.class);
    @Autowired
    XMLMessageConverter converter;
    @Autowired
    MessageDispatcher messageDispatcher;
    @Autowired
    private BrokerPropertiesService propertiesService;
    @ConfigurableValue(valueType="Boolean", description="If true, then some messages are not converted to java")
    private Boolean rawXML = false;
    @ConfigurableValue(valueType="List", description="These xml message types are passed without conversion")
    private List<String> rawMsgTypes = new ArrayList<String>();
    @ConfigurableValue(valueType="List", description="These xml message types are passed after conversion")
    private List<String> cookedMsgTypes = new ArrayList<String>();

    public void initialize() {
        this.propertiesService.configureMe(this);
    }

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            try {
                log.debug("onMessage(Message) - receiving a message");
                this.onMessage(((TextMessage)message).getText());
            }
            catch (JMSException e) {
                log.error("failed to extract text from TextMessage", (Throwable)e);
            }
        }
    }

    private void onMessage(String xml) {
        log.info("onMessage(String) - received message:\n" + xml);
        Object message = this.converter.fromXML(xml);
        log.debug("onMessage(String) - received message of type " + message.getClass().getSimpleName());
        this.messageDispatcher.routeMessage(message);
    }
}

