/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker.core;

import java.io.File;
import java.util.Date;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.powertac.samplebroker.core.PowerTacBroker;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class BrokerRunner {
    private static Logger log = LogManager.getLogger();
    private AbstractApplicationContext context;
    private PowerTacBroker broker;

    public void processCmdLine(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec jmsUrlOption = parser.accepts("jms-url").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec configOption = parser.accepts("config").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec repeatCountOption = parser.accepts("repeat-count").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec repeatHoursOption = parser.accepts("repeat-hours").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec queueNameOption = parser.accepts("queue-name").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec serverQueueOption = parser.accepts("server-queue").withRequiredArg().ofType(String.class);
        parser.accepts("no-ntp");
        parser.accepts("interactive");
        OptionSet options = parser.parse(args);
        File configFile = null;
        String jmsUrl = null;
        boolean noNtp = false;
        boolean interactive = false;
        String queueName = null;
        String serverQueue = null;
        Integer repeatCount = 1;
        long end = 0L;
        try {
            System.out.println("Options: ");
            if (options.has((OptionSpec)configOption)) {
                configFile = (File)options.valueOf((OptionSpec)configOption);
                System.out.println("  config=" + configFile.getName());
            }
            if (options.has((OptionSpec)jmsUrlOption)) {
                jmsUrl = (String)options.valueOf((OptionSpec)jmsUrlOption);
                System.out.println("  jms-url=" + jmsUrl);
            }
            if (options.has("no-ntp")) {
                noNtp = true;
                System.out.println("  no ntp - estimate offset");
            }
            if (options.has((OptionSpec)repeatCountOption)) {
                repeatCount = (Integer)options.valueOf((OptionSpec)repeatCountOption);
                System.out.println("  repeat " + repeatCount + " times");
            } else if (options.has((OptionSpec)repeatHoursOption)) {
                Integer repeatHours = (Integer)options.valueOf((OptionSpec)repeatCountOption);
                System.out.println("  repeat for " + repeatHours + " hours");
                long now = new Date().getTime();
                end = now + (long)(3600000 * repeatHours);
            }
            if (options.has((OptionSpec)queueNameOption)) {
                queueName = (String)options.valueOf((OptionSpec)queueNameOption);
                System.out.println("  queue-name=" + queueName);
            }
            if (options.has((OptionSpec)serverQueueOption)) {
                serverQueue = (String)options.valueOf((OptionSpec)serverQueueOption);
                System.out.println("  server-queue=" + serverQueue);
            }
            if (options.has("interactive")) {
                interactive = true;
                System.out.println("  interactive=true");
            }
            int counter = 0;
            while (repeatCount != null && repeatCount > 0 || new Date().getTime() < end) {
                ++counter;
                if (this.context == null) {
                    this.context = new ClassPathXmlApplicationContext("broker.xml");
                } else {
                    this.context.close();
                    this.context.refresh();
                }
                this.reopenLogs(counter);
                this.context.registerShutdownHook();
                this.broker = (PowerTacBroker)this.context.getBeansOfType(PowerTacBroker.class).values().toArray()[0];
                System.out.println("Starting session " + counter);
                log.info("Starting session {}", (Object)counter);
                this.broker.startSession(configFile, jmsUrl, noNtp, queueName, serverQueue, end, interactive);
                if (repeatCount == null) continue;
                repeatCount = repeatCount - 1;
            }
        }
        catch (OptionException e) {
            System.err.println("Bad command argument: " + e.toString());
        }
    }

    private void reopenLogs(int counter) {
        System.setProperty("logfile", "log/broker" + counter + ".trace");
        System.setProperty("statefile", "log/broker" + counter + ".state");
        ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
    }
}

