/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker.core;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.IdGenerator;
import org.powertac.common.XMLMessageConverter;
import org.powertac.samplebroker.core.JmsManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Service;

@Service
public class MessageDispatcher {
    private static Logger log = LogManager.getLogger(MessageDispatcher.class);
    @Autowired
    private XMLMessageConverter converter;
    @Autowired
    private JmsTemplate template;
    @Autowired
    private JmsManagementService jmsManagementService;
    private HashMap<Class<?>, Set<Object>> registrations = new HashMap();
    String key = "";

    void setKey(String key) {
        this.key = key;
    }

    public void registerMessageHandler(Object handler, Class<?> messageType) {
        Set<Object> reg = this.registrations.get(messageType);
        if (reg == null) {
            reg = new HashSet<Object>();
            this.registrations.put(messageType, reg);
        }
        reg.add(handler);
    }

    public void routeMessage(Object message) {
        Class<?> clazz = message.getClass();
        log.debug("Route " + clazz.getName());
        Set<Object> targets = this.registrations.get(clazz);
        if (targets == null) {
            log.warn("no targets for message of type " + clazz.getName());
            return;
        }
        for (Object target : targets) {
            org.powertac.util.MessageDispatcher.dispatch((Object)target, (String)"handleMessage", (Object[])new Object[]{message});
        }
    }

    public void sendMessage(Object message) {
        if (!this.validateId(message)) {
            return;
        }
        final String text = String.valueOf(this.key) + this.converter.toXML(message);
        log.info("sending text: \n" + text);
        this.template.send(this.jmsManagementService.getServerQueueName(), new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                TextMessage message = session.createTextMessage(text);
                return message;
            }
        });
    }

    private boolean validateId(Object thing) {
        try {
            Field idField = thing.getClass().getDeclaredField("id");
            idField.setAccessible(true);
            long value = idField.getLong(thing);
            if (IdGenerator.getPrefix() != IdGenerator.extractPrefix((long)value)) {
                log.error("Invalid id value " + value + " in message " + thing.toString());
                return false;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return true;
        }
        catch (SecurityException e) {
            log.error("Exception accessing id field: " + e.toString());
        }
        catch (IllegalArgumentException e) {
            log.error("Exception reading id field: " + e.toString());
        }
        catch (IllegalAccessException e) {
            log.error("Exception reading id field: " + e.toString());
        }
        return true;
    }

    Set<Object> getRegistrations(Class<?> messageType) {
        return this.registrations.get(messageType);
    }
}

