/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker.core;

import java.io.File;
import java.util.Date;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.powertac.common.IdGenerator;
import org.powertac.samplebroker.core.PowerTacBroker;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class BrokerRunner {
    private static Logger log = LogManager.getLogger();
    private AbstractApplicationContext context;
    private PowerTacBroker broker;

    public void processCmdLine(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec jmsUrlOption = parser.accepts("jms-url").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec configOption = parser.accepts("config").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec repeatCountOption = parser.accepts("repeat-count").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec repeatHoursOption = parser.accepts("repeat-hours").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec queueNameOption = parser.accepts("queue-name").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec serverQueueOption = parser.accepts("server-queue").withRequiredArg().ofType(String.class);
        parser.accepts("ipc-adapter");
        parser.accepts("interactive");
        ArgumentAcceptingOptionSpec propOption = parser.accepts("prop").withRequiredArg().ofType(String.class);
        OptionSet options = parser.parse(args);
        File configFile = null;
        Integer repeatCount = 1;
        Integer repeatHours = 0;
        long end = 0L;
        PropertiesConfiguration cliProps = new PropertiesConfiguration();
        try {
            System.out.println("<options");
            if (options.has((OptionSpec)configOption)) {
                configFile = (File)options.valueOf((OptionSpec)configOption);
                System.out.println(" config=\"" + configFile.getName() + "\"");
            }
            if (options.has((OptionSpec)jmsUrlOption)) {
                cliProps.setProperty("samplebroker.core.powerTacBroker.jmsBrokerUrl", options.valueOf((OptionSpec)jmsUrlOption));
                System.out.print(" jms-url=\"" + (String)options.valueOf((OptionSpec)jmsUrlOption) + "\"");
            }
            if (options.has((OptionSpec)repeatCountOption)) {
                repeatCount = (Integer)options.valueOf((OptionSpec)repeatCountOption);
                System.out.print(" repeat-count=\"" + repeatCount + "\"");
            } else if (options.has((OptionSpec)repeatHoursOption)) {
                repeatHours = (Integer)options.valueOf((OptionSpec)repeatHoursOption);
                System.out.print(" repeat-hours=\"" + repeatHours + "\"");
                long now = new Date().getTime();
                end = now + (long)(3600000 * repeatHours);
            }
            if (options.has((OptionSpec)queueNameOption)) {
                cliProps.setProperty("samplebroker.core.powerTacBroker.brokerQueueName", options.valueOf((OptionSpec)queueNameOption));
                System.out.print(" queue-name=\"" + (String)options.valueOf((OptionSpec)queueNameOption) + "\"");
            }
            if (options.has((OptionSpec)serverQueueOption)) {
                cliProps.setProperty("samplebroker.core.powerTacBroker.serverQueueName", options.valueOf((OptionSpec)serverQueueOption));
                System.out.print(" server-queue=\"" + (String)options.valueOf((OptionSpec)serverQueueOption) + "\"");
            }
            if (options.has("interactive")) {
                cliProps.setProperty("samplebroker.core.powerTacBroker.interactive", (Object)"true");
                System.out.print(" interactive=\"true\"");
            }
            if (options.has("ipc-adapter")) {
                cliProps.setProperty("samplebroker.core.brokerMessageReceiver.ipcAdapter", (Object)"true");
                System.out.println("Using ipc-adapter to pass raw xml.");
            }
            if (options.has((OptionSpec)propOption)) {
                List values = options.valuesOf((OptionSpec)propOption);
                for (String value : values) {
                    int colon = value.indexOf(":");
                    if (colon <= 0) continue;
                    String name = value.substring(0, colon);
                    String val = value.substring(colon + 1);
                    cliProps.setProperty(name, (Object)val);
                    System.out.print(" " + name + "=" + val);
                }
            }
            System.out.println("/>");
            int counter = 0;
            while (repeatCount != null && repeatCount > 0 || new Date().getTime() < end) {
                ++counter;
                if (this.context == null) {
                    this.context = new ClassPathXmlApplicationContext("broker.xml");
                } else {
                    this.context.close();
                    this.context.refresh();
                }
                this.reopenLogs(counter);
                IdGenerator.recycle();
                this.context.registerShutdownHook();
                this.broker = (PowerTacBroker)this.context.getBeansOfType(PowerTacBroker.class).values().toArray()[0];
                System.out.println("Starting session " + counter);
                log.info("Starting session {}", (Object)counter);
                this.broker.startSession(cliProps, configFile, end);
                if (repeatCount == null) continue;
                repeatCount = repeatCount - 1;
            }
        }
        catch (OptionException e) {
            System.err.println("Bad command argument: " + e.toString());
        }
    }

    private void reopenLogs(int counter) {
        System.setProperty("logfile", "log/broker" + counter + ".trace");
        System.setProperty("statefile", "log/broker" + counter + ".state");
        ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
    }
}

