/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker.core;

import java.util.concurrent.Executor;
import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.samplebroker.core.BrokerPropertiesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.stereotype.Service;

@Service
public class JmsManagementService {
    private static Logger log = LogManager.getLogger(JmsManagementService.class);
    @Resource(name="jmsFactory")
    private ConnectionFactory connectionFactory;
    @Autowired
    private Executor taskExecutor;
    @Autowired
    private BrokerPropertiesService brokerPropertiesService;
    private String serverQueueName = "serverInput";
    private String jmsBrokerUrl = "tcp://localhost:61616";
    private boolean connectionOpen = false;
    private DefaultMessageListenerContainer container;

    public void init(String overridenBrokerUrl, String serverQueueName) {
        CachingConnectionFactory cachingConnectionFactory;
        this.brokerPropertiesService.configureMe(this);
        this.serverQueueName = serverQueueName;
        if (overridenBrokerUrl != null && !overridenBrokerUrl.isEmpty()) {
            this.setJmsBrokerUrl(overridenBrokerUrl);
        }
        ActiveMQConnectionFactory amqConnectionFactory = null;
        if (this.connectionFactory instanceof PooledConnectionFactory) {
            PooledConnectionFactory pooledConnectionFactory = (PooledConnectionFactory)this.connectionFactory;
            if (pooledConnectionFactory.getConnectionFactory() instanceof ActiveMQConnectionFactory) {
                amqConnectionFactory = (ActiveMQConnectionFactory)pooledConnectionFactory.getConnectionFactory();
            }
        } else if (this.connectionFactory instanceof CachingConnectionFactory && (cachingConnectionFactory = (CachingConnectionFactory)this.connectionFactory).getTargetConnectionFactory() instanceof ActiveMQConnectionFactory) {
            amqConnectionFactory = (ActiveMQConnectionFactory)cachingConnectionFactory.getTargetConnectionFactory();
        }
        if (amqConnectionFactory != null) {
            amqConnectionFactory.setBrokerURL(this.getJmsBrokerUrl());
            try {
                Connection connection = amqConnectionFactory.createConnection();
                connection.start();
            }
            catch (JMSException e) {
                log.error(e.toString());
            }
        }
    }

    public void registerMessageListener(MessageListener listener, String destinationName) {
        log.info("registerMessageListener(" + destinationName + ", " + listener + ")");
        this.container = new DefaultMessageListenerContainer();
        this.container.setConnectionFactory(this.connectionFactory);
        this.container.setDestinationName(destinationName);
        this.container.setMessageListener((Object)listener);
        this.container.setTaskExecutor(this.taskExecutor);
        this.container.afterPropertiesSet();
        this.container.start();
    }

    public synchronized void shutdown() {
        Runnable callback = new Runnable(){

            @Override
            public void run() {
                JmsManagementService.this.closeConnection();
            }
        };
        this.container.stop(callback);
        while (this.connectionOpen) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized void closeConnection() {
        this.connectionOpen = false;
        this.notifyAll();
    }

    public String getServerQueueName() {
        return this.serverQueueName;
    }

    public void setServerQueueName(String serverQueueName) {
        this.serverQueueName = serverQueueName;
    }

    public String getJmsBrokerUrl() {
        return this.jmsBrokerUrl;
    }

    @ConfigurableValue(valueType="String", description="JMS broker URL to use")
    public void setJmsBrokerUrl(String jmsBrokerUrl) {
        this.jmsBrokerUrl = jmsBrokerUrl;
    }
}

