/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker.core;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.IdGenerator;
import org.powertac.common.TimeService;
import org.powertac.common.Timeslot;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.msg.BrokerAccept;
import org.powertac.common.msg.BrokerAuthentication;
import org.powertac.common.msg.PauseRelease;
import org.powertac.common.msg.PauseRequest;
import org.powertac.common.msg.SimEnd;
import org.powertac.common.msg.SimPause;
import org.powertac.common.msg.SimResume;
import org.powertac.common.msg.SimStart;
import org.powertac.common.msg.TimeslotComplete;
import org.powertac.common.msg.TimeslotUpdate;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.DomainRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.samplebroker.core.BrokerMessageReceiver;
import org.powertac.samplebroker.core.BrokerPropertiesService;
import org.powertac.samplebroker.core.BrokerTournamentService;
import org.powertac.samplebroker.core.JmsManagementService;
import org.powertac.samplebroker.core.MessageDispatcher;
import org.powertac.samplebroker.interfaces.Activatable;
import org.powertac.samplebroker.interfaces.BrokerContext;
import org.powertac.samplebroker.interfaces.Initializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PowerTacBroker
implements BrokerContext {
    private static Logger log = LogManager.getLogger(PowerTacBroker.class);
    @Autowired
    private BrokerPropertiesService propertiesService;
    @Autowired
    private TimeService timeService;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private BrokerRepo brokerRepo;
    @Autowired
    private MessageDispatcher router;
    @Autowired
    private JmsManagementService jmsManagementService;
    @Autowired
    private BrokerTournamentService brokerTournamentService;
    @Autowired
    private BrokerMessageReceiver brokerMessageReceiver;
    @Autowired
    private CustomerRepo customerRepo;
    @ConfigurableValue(valueType="Integer", description="length of customer usage records")
    private Integer usageRecordLength = 168;
    @ConfigurableValue(valueType="Integer", description="Login retry timeout in msec")
    private Integer loginRetryTimeout = 3000;
    @ConfigurableValue(valueType="Integer", description="Time limit in msec to retry logins before giving up")
    private Integer retryTimeLimit = 180000;
    @ConfigurableValue(valueType="String", description="Broker username")
    private String username = "broker";
    @ConfigurableValue(valueType="String", description="Broker login password")
    private String password = "password";
    @ConfigurableValue(valueType="String", description="Name of tournament")
    private String tourneyName = "";
    @ConfigurableValue(valueType="String", description="url for tournament login")
    private String tourneyUrl = "";
    @ConfigurableValue(valueType="String", description="Authorization token for tournament")
    private String authToken = "";
    @ConfigurableValue(valueType="String", description="Name of incoming message queue")
    private String serverQueueName = "serverInput";
    @ConfigurableValue(valueType="String", description="URL for JMS message broker running on server")
    private String jmsBrokerUrl = null;
    @ConfigurableValue(valueType="String", description="Name of outgoing message queue")
    private String brokerQueueName = null;
    @ConfigurableValue(valueType="Boolean", description="If true, then broker pauses in each timeslot")
    private boolean interactive = false;
    private long quittingTime = 0L;
    private int currentTimeslot = 0;
    private int timeslotCompleted = 0;
    private boolean running = false;
    private BrokerAdapter adapter;
    private long brokerTime = 0L;
    private long serverClockOffset = 0L;

    public void startSession(PropertiesConfiguration cli, File configFile, long end) {
        this.quittingTime = end;
        this.propertiesService.addProperties(cli);
        if (configFile != null && configFile.canRead()) {
            this.propertiesService.setUserConfig(configFile);
        }
        this.propertiesService.configureMe(this);
        this.init();
        this.run();
    }

    public void init() {
        this.adapter = new BrokerAdapter(this.username);
        this.brokerRepo.add((Broker)this.adapter);
        this.brokerMessageReceiver.initialize();
        List initializers = SpringApplicationContext.listBeansOfType(Initializable.class);
        for (Initializable svc : initializers) {
            svc.initialize(this);
            this.registerMessageHandlers(svc);
        }
        this.registerMessageHandlers(this);
    }

    private void registerMessageHandlers(Object thing) {
        Method[] methods;
        Class<?> thingClass = thing.getClass();
        Method[] methodArray = methods = thingClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] args;
            Method method = methodArray[n2];
            if (method.getName().equals("handleMessage") && 1 == (args = method.getParameterTypes()).length) {
                log.info("Register " + thing.getClass().getSimpleName() + ".handleMessage(" + args[0].getSimpleName() + ")");
                this.router.registerMessageHandler(thing, args[0]);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.brokerQueueName == null) {
            this.brokerQueueName = this.username;
        }
        if (this.tourneyUrl != null && !this.tourneyUrl.isEmpty() && this.brokerTournamentService.login(this.tourneyName, this.tourneyUrl, this.authToken, this.quittingTime)) {
            this.jmsBrokerUrl = this.brokerTournamentService.getJmsUrl();
            this.brokerQueueName = this.brokerTournamentService.getBrokerQueueName();
            this.serverQueueName = this.brokerTournamentService.getServerQueueName();
        }
        this.adapter.setQueueName(this.brokerQueueName);
        this.jmsManagementService.init(this.jmsBrokerUrl, this.serverQueueName);
        this.jmsManagementService.registerMessageListener(this.brokerMessageReceiver, this.brokerQueueName);
        log.info("Listening on queue " + this.brokerQueueName);
        BrokerAuthentication auth = new BrokerAuthentication(this.username, this.password);
        PowerTacBroker powerTacBroker = this;
        synchronized (powerTacBroker) {
            long now = new Date().getTime();
            while (!this.adapter.isEnabled() && new Date().getTime() - now < (long)this.retryTimeLimit.intValue()) {
                try {
                    this.brokerTime = new Date().getTime();
                    auth.setBrokerTime(this.brokerTime);
                    this.sendMessage(auth);
                    this.wait(this.loginRetryTimeout.intValue());
                }
                catch (InterruptedException interruptedException) {
                    log.warn("Interrupted!");
                    break;
                }
                catch (Exception ex) {
                    log.info("log attempt failed " + ex.toString());
                    try {
                        Thread.sleep(this.loginRetryTimeout.intValue());
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (!this.adapter.isEnabled()) {
            this.jmsManagementService.shutdown();
            return;
        }
        AgentRunner runner = new AgentRunner(this);
        runner.start();
        try {
            runner.join();
        }
        catch (InterruptedException interruptedException) {
            log.warn("Interrupted!");
        }
        this.jmsManagementService.shutdown();
    }

    @Override
    public Broker getBroker() {
        return this.adapter;
    }

    @Override
    public String getBrokerUsername() {
        return this.adapter.getUsername();
    }

    @Override
    public Instant getBaseTime() {
        return this.timeService.getBaseInstant();
    }

    @Override
    public int getUsageRecordLength() {
        return this.usageRecordLength;
    }

    @Override
    public List<String> getBrokerList() {
        return this.brokerRepo.findRetailBrokerNames();
    }

    public long getServerTimeOffset() {
        return this.serverClockOffset;
    }

    @Override
    public void registerMessageHandler(Object handler, Class<?> messageType) {
        this.router.registerMessageHandler(handler, messageType);
    }

    @Override
    public void sendMessage(Object message) {
        if (message != null) {
            this.router.sendMessage(message);
        }
    }

    public synchronized void handleMessage(BrokerAccept accept) {
        this.adapter.setEnabled(true);
        IdGenerator.setPrefix((int)accept.getPrefix());
        this.adapter.setKey(accept.getKey());
        this.router.setKey(accept.getKey());
        this.notifyAll();
    }

    public void handleMessage(Competition comp) {
        Competition.setCurrent((Competition)comp);
        Instant bootBaseTime = comp.getSimulationBaseTime();
        int bootTimeslotCount = comp.getBootstrapTimeslotCount() + comp.getBootstrapDiscardedTimeslots();
        this.timeService.setClockParameters(comp.getClockParameters());
        this.timeService.init(bootBaseTime.plus((long)bootTimeslotCount * comp.getTimeslotDuration()));
        log.info("Sim start time: " + this.timeService.getCurrentDateTime().toString());
        List repos = SpringApplicationContext.listBeansOfType(DomainRepo.class);
        log.debug("found " + repos.size() + " repos");
        for (DomainRepo repo : repos) {
            repo.recycle();
        }
        for (CustomerInfo customer : comp.getCustomers()) {
            this.customerRepo.add(customer);
        }
        for (String brokerName : comp.getBrokers()) {
            if (brokerName.equals(this.adapter.getUsername())) continue;
            Broker competitor = new Broker(brokerName);
            log.info("adding competitor " + brokerName);
            this.brokerRepo.add(competitor);
        }
    }

    public void handleMessage(SimPause sp) {
        log.info("Paused at " + this.timeService.getCurrentDateTime().toString());
    }

    public void handleMessage(SimResume sr) {
        log.info("Resumed");
        this.timeService.setStart(sr.getStart().getMillis() - this.serverClockOffset);
        this.timeService.updateTime();
    }

    public void handleMessage(SimStart ss) {
        log.info("SimStart - start time is " + ss.getStart().toString());
        this.timeService.setStart(ss.getStart().getMillis() - this.serverClockOffset);
        this.timeService.updateTime();
        log.info("SimStart - clock set to " + this.timeService.getCurrentDateTime().toString());
    }

    public synchronized void handleMessage(SimEnd se) {
        log.info("SimEnd received");
        this.running = false;
        this.notifyAll();
    }

    public synchronized void handleMessage(TimeslotUpdate tu) {
        Timeslot old = this.timeslotRepo.currentTimeslot();
        this.timeService.updateTime();
        log.info("TimeslotUpdate at " + this.timeService.getCurrentDateTime().toString());
        int index = old.getSerialNumber();
        while (index < tu.getFirstEnabled()) {
            this.timeslotRepo.findOrCreateBySerialNumber(index);
            this.currentTimeslot = index++;
        }
        index = tu.getFirstEnabled();
        while (index <= tu.getLastEnabled()) {
            this.timeslotRepo.findOrCreateBySerialNumber(index);
            ++index;
        }
    }

    public synchronized void handleMessage(TimeslotComplete tc) {
        if (tc.getTimeslotIndex() == this.currentTimeslot) {
            this.timeslotCompleted = this.currentTimeslot;
            this.notifyAll();
        } else {
            this.timeslotCompleted = this.timeslotRepo.currentSerialNumber();
            log.warn("Skipped timeslot " + tc.getTimeslotIndex());
        }
    }

    synchronized int waitForActivation(int index) {
        try {
            int remainingTimeouts = 6;
            while (this.running && this.timeslotCompleted <= index) {
                String msg;
                long maxWait = 120000L;
                long nowStamp = System.currentTimeMillis();
                this.wait(maxWait);
                long diff = System.currentTimeMillis() - nowStamp;
                if (diff < maxWait) continue;
                if (!this.interactive && index != 0) {
                    msg = "worker thread waited more than " + maxWait / 1000L + " secs for server, abandoning game";
                    System.out.println("\n" + msg + "\n");
                    log.warn(msg);
                    this.running = false;
                    continue;
                }
                if (--remainingTimeouts > 0) continue;
                msg = "worker thread waited more than 720 secs for server, abandoning game";
                System.out.println("\n" + msg + "\n");
                log.warn(msg);
                this.running = false;
            }
        }
        catch (InterruptedException ie) {
            log.warn("activation interrupted: " + ie);
        }
        return this.timeslotCompleted;
    }

    protected int getTimeslotCompleted() {
        return this.timeslotCompleted;
    }

    class AgentRunner
    extends Thread {
        PowerTacBroker parent;
        int timeslotIndex = 0;

        public AgentRunner(PowerTacBroker parent) {
            this.parent = parent;
        }

        @Override
        public void run() {
            PowerTacBroker.this.running = true;
            while (true) {
                this.timeslotIndex = PowerTacBroker.this.waitForActivation(this.timeslotIndex);
                if (!PowerTacBroker.this.running) {
                    log.info("worker thread exits at ts " + this.timeslotIndex);
                    return;
                }
                Timeslot current = PowerTacBroker.this.timeslotRepo.currentTimeslot();
                log.info("activate at " + PowerTacBroker.this.timeService.getCurrentDateTime().toString() + ", timeslot " + current.getSerialNumber());
                if (PowerTacBroker.this.interactive) {
                    long now = new Date().getTime();
                    log.info("Pause at {}", (Object)PowerTacBroker.this.timeService.getCurrentDateTime().toString());
                    PowerTacBroker.this.sendMessage(new PauseRequest((Broker)PowerTacBroker.this.adapter));
                    this.activateServices();
                    PowerTacBroker.this.sendMessage(new PauseRelease((Broker)PowerTacBroker.this.adapter));
                    log.info("Pause release after {} msec", (Object)(new Date().getTime() - now));
                    continue;
                }
                this.activateServices();
            }
        }

        private void activateServices() {
            List services = SpringApplicationContext.listBeansOfType(Activatable.class);
            for (Activatable svc : services) {
                if (this.timeslotIndex < PowerTacBroker.this.currentTimeslot) {
                    log.warn("broker late, ts=" + this.timeslotIndex);
                    break;
                }
                svc.activate(this.timeslotIndex);
            }
        }
    }

    class BrokerAdapter
    extends Broker {
        public BrokerAdapter(String username) {
            super(username);
        }

        public void receiveMessage(Object msg) {
            if (msg != null) {
                if (!this.isEnabled() && !(msg instanceof BrokerAccept)) {
                    return;
                }
                PowerTacBroker.this.router.routeMessage(msg);
            }
        }
    }
}

