/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker.core;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.samplebroker.core.BrokerPropertiesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Service
public class BrokerTournamentService {
    private static Logger log = LogManager.getLogger(BrokerTournamentService.class);
    @Autowired
    private BrokerPropertiesService brokerPropertiesService;
    private String jmsUrl = null;
    private String brokerQueueName = null;
    private String serverQueueName = null;
    private String authToken = null;
    private String tourneyName = null;
    @ConfigurableValue(valueType="String", description="Response type to receive from the TS xml or json")
    private String responseType = "xml";
    @ConfigurableValue(valueType="Integer", description="Maximum number of tries to connect to Tournament Scheduler")
    private int maxTry = 50;

    public void init() {
        this.brokerPropertiesService.configureMe(this);
    }

    public String getJmsUrl() {
        return this.jmsUrl;
    }

    public String getServerQueueName() {
        return this.serverQueueName;
    }

    public String getBrokerQueueName() {
        return this.brokerQueueName;
    }

    private void spin(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private boolean loginMaybe(String tsUrl) {
        block8: {
            Node doneNode;
            block7: {
                Node loginNode;
                Document doc;
                block6: {
                    if (this.responseType.compareTo("xml") != 0) {
                        log.fatal("Error: invalid responseType " + this.responseType);
                        return false;
                    }
                    try {
                        String restAuthToken = "authToken=" + this.authToken;
                        String restTourneyName = "requestJoin=" + this.tourneyName;
                        String restResponseType = "type=" + this.responseType;
                        String finalUrl = String.valueOf(tsUrl) + "?" + restAuthToken + "&" + restTourneyName + "&" + restResponseType;
                        System.out.printf("Connecting to TS at %s\nTournament : %s\n", tsUrl, this.tourneyName);
                        log.info("Connecting to TS at " + finalUrl);
                        log.info("Tournament : " + this.tourneyName);
                        URL url = new URL(finalUrl);
                        URLConnection conn = url.openConnection();
                        InputStream input = conn.getInputStream();
                        System.out.println("Parsing message..");
                        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                        doc = docBuilder.parse(input);
                        doc.getDocumentElement().normalize();
                        Node retryNode = doc.getElementsByTagName("retry").item(0);
                        loginNode = doc.getElementsByTagName("login").item(0);
                        doneNode = doc.getElementsByTagName("done").item(0);
                        if (retryNode == null) break block6;
                        String checkRetry = retryNode.getFirstChild().getNodeValue();
                        System.out.println("No games available at this moment");
                        System.out.println("Retry in " + checkRetry + " seconds\n");
                        log.info("Retry message received for : " + checkRetry + " seconds");
                        this.spin(Integer.parseInt(checkRetry));
                        return false;
                    }
                    catch (Exception e) {
                        --this.maxTry;
                        System.out.println("Retries left: " + this.maxTry);
                        e.printStackTrace();
                        log.fatal("Error making connection to Tournament Scheduler");
                        log.fatal(e.getMessage());
                        this.spin(20);
                        return false;
                    }
                }
                if (loginNode == null) break block7;
                this.jmsUrl = this.getValue(doc, "jmsUrl");
                this.brokerQueueName = this.getValue(doc, "queueName");
                this.serverQueueName = this.getValue(doc, "serverQueue");
                System.out.printf("Login response received!\n  jmsUrl=%s\n  queueName=%s\n  serverQueue=%s\n", this.jmsUrl, this.brokerQueueName, this.serverQueueName);
                log.info("Login response received!");
                log.info("  jmsUrl=" + this.jmsUrl);
                log.info("  brokerQueueName=" + this.brokerQueueName);
                log.info("  serverQueueName=" + this.serverQueueName);
                return true;
            }
            if (doneNode == null) break block8;
            System.out.println("Received Done Message, no more games!");
            log.info("Received Done Message, no more games!");
            this.maxTry = 0;
            return false;
        }
        log.fatal("Invalid message type received");
        return false;
    }

    public boolean login(String tournamentName, String tsUrl, String authToken, long quittingTime) {
        this.tourneyName = tournamentName;
        this.authToken = authToken;
        if (this.authToken != null && tsUrl != null) {
            System.out.println();
            while (this.maxTry > 0 && (quittingTime == 0L || new Date().getTime() < quittingTime)) {
                if (!this.loginMaybe(tsUrl)) continue;
                log.info("Login Successful!");
                return true;
            }
            System.out.println("Max attempts reached...shutting down");
            log.fatal("Max attempts to log in reached");
            System.exit(0);
        } else {
            log.fatal("Incorrect Tournament Scheduler URL or Broker Auth Token");
            System.exit(0);
        }
        return false;
    }

    private String getValue(Document doc, String tag) {
        return doc.getElementsByTagName(tag).item(0).getFirstChild().getNodeValue();
    }
}

