/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.samplebroker.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.XMLMessageConverter;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.samplebroker.core.BrokerPropertiesService;
import org.powertac.samplebroker.core.MessageDispatcher;
import org.powertac.samplebroker.interfaces.IpcAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BrokerMessageReceiver
implements MessageListener {
    private static Logger log = LogManager.getLogger(BrokerMessageReceiver.class);
    @Autowired
    private XMLMessageConverter converter;
    @Autowired
    private MessageDispatcher messageDispatcher;
    @Autowired
    private BrokerPropertiesService propertiesService;
    private IpcAdapter adapter = null;
    @ConfigurableValue(valueType="List", description="These xml message types are passed without conversion")
    private List<String> rawMsgTypes = new ArrayList<String>();
    @ConfigurableValue(valueType="List", description="These xml message types are passed after conversion")
    private List<String> cookedMsgTypes = new ArrayList<String>();
    @ConfigurableValue(valueType="Boolean", description="If true, do xml forwarding")
    private boolean ipcAdapter = false;
    private HashSet<String> rawTypes;
    private HashSet<String> cookedTypes;
    private Pattern tagRe = Pattern.compile("<([-_\\w]+)[\\s/>]");

    public void initialize() {
        this.propertiesService.configureMe(this);
        if (this.ipcAdapter) {
            if (!this.setMessageAdapter()) {
                return;
            }
            this.rawTypes = new HashSet();
            this.rawTypes.addAll(this.rawMsgTypes);
            this.cookedTypes = new HashSet();
            this.cookedTypes.addAll(this.cookedMsgTypes);
        }
    }

    private boolean setMessageAdapter() {
        if (this.adapter != null) {
            return true;
        }
        List adapters = SpringApplicationContext.listBeansOfType(IpcAdapter.class);
        if (adapters.size() == 0) {
            log.error("Raw xml specified, but no adapter available");
            return false;
        }
        this.adapter = (IpcAdapter)adapters.get(0);
        log.info("Using {} for xml forwarding", (Object)this.adapter.getClass().getName());
        return true;
    }

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            try {
                log.debug("onMessage(Message) - receiving a message");
                String msg = ((TextMessage)message).getText();
                log.info("received message:\n" + msg);
                if (this.adapter != null) {
                    Matcher m = this.tagRe.matcher(msg);
                    if (m.lookingAt()) {
                        String tag = m.group(1);
                        log.info("msg tag: {}", (Object)tag);
                        if (this.cookedTypes.contains(tag)) {
                            this.onMessage(msg);
                        }
                        if (this.rawTypes.contains(tag)) {
                            this.adapter.exportMessage(msg);
                        }
                    }
                } else {
                    this.onMessage(msg);
                }
            }
            catch (JMSException e) {
                log.error("failed to extract text from TextMessage", (Throwable)e);
            }
        }
    }

    private void onMessage(String xml) {
        Object message = this.converter.fromXML(xml);
        log.debug("onMessage(String) - received message of type " + message.getClass().getSimpleName());
        this.messageDispatcher.routeMessage(message);
    }
}

