/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.powertac.common.CustomerInfo;
import org.powertac.common.repo.DomainRepo;
import org.springframework.stereotype.Repository;

@Repository
public class CustomerRepo
implements DomainRepo {
    private static Logger log = Logger.getLogger((String)CustomerRepo.class.getName());
    private HashMap<Long, CustomerInfo> customers = new HashMap();

    public CustomerInfo createCustomerInfo(String name, int population) {
        CustomerInfo result = new CustomerInfo(name, population);
        this.customers.put(result.getId(), result);
        return result;
    }

    public void add(CustomerInfo customer) {
        this.customers.put(customer.getId(), customer);
    }

    public Collection<CustomerInfo> list() {
        return this.customers.values();
    }

    public CustomerInfo findById(long id) {
        return this.customers.get(id);
    }

    public CustomerInfo findByName(String name) {
        CustomerInfo result = null;
        for (CustomerInfo customer : this.customers.values()) {
            if (!name.equals(customer.getName())) continue;
            return customer;
        }
        return result;
    }

    @Override
    public void recycle() {
        this.customers.clear();
    }
}

