/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.common.Orderbook;
import org.powertac.common.TimeService;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.DomainRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class OrderbookRepo
implements DomainRepo {
    private static Logger log = Logger.getLogger((String)OrderbookRepo.class.getName());
    @Autowired
    private TimeService timeService;
    private HashMap<Timeslot, List<Orderbook>> orderbookIndex = new HashMap();
    private HashMap<Timeslot, Orderbook> timeslotIndex = new HashMap();
    private HashMap<Timeslot, Orderbook> spotIndex = new HashMap();

    public Orderbook makeOrderbook(Timeslot timeslot, Double clearingPrice) {
        List<Orderbook> obList;
        Orderbook result = new Orderbook(timeslot, clearingPrice, this.timeService.getCurrentTime());
        this.timeslotIndex.put(timeslot, result);
        if (clearingPrice != null) {
            this.spotIndex.put(timeslot, result);
        }
        if ((obList = this.orderbookIndex.get(timeslot)) == null) {
            obList = new ArrayList<Orderbook>();
            this.orderbookIndex.put(timeslot, obList);
        }
        obList.add(result);
        log.debug((Object)("Created new Orderbook ts=" + timeslot.getSerialNumber() + ", clearingPrice=" + clearingPrice));
        return result;
    }

    public Orderbook findByTimeslot(Timeslot timeslot) {
        return this.timeslotIndex.get(timeslot);
    }

    public Orderbook findSpotByTimeslot(Timeslot timeslot) {
        return this.spotIndex.get(timeslot);
    }

    public List<Orderbook> findAllByTimeslot(Timeslot timeslot) {
        return this.orderbookIndex.get(timeslot);
    }

    public int size() {
        return this.timeslotIndex.size();
    }

    @Override
    public void recycle() {
        this.timeslotIndex.clear();
        this.spotIndex.clear();
    }
}

