/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.SortedSet;
import java.util.TreeSet;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.Instant;
import org.powertac.common.IdGenerator;
import org.powertac.common.OrderbookOrder;
import org.powertac.common.Timeslot;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;
import org.powertac.common.xml.TimeslotConverter;

@Domain
@XStreamAlias(value="orderbook")
public class Orderbook {
    @XStreamAsAttribute
    private long id;
    private Instant dateExecuted;
    @XStreamConverter(value=TimeslotConverter.class)
    private Timeslot timeslot;
    @XStreamAsAttribute
    private Double clearingPrice;
    @XStreamImplicit(itemFieldName="bid")
    private SortedSet<OrderbookOrder> bids;
    @XStreamImplicit(itemFieldName="ask")
    private SortedSet<OrderbookOrder> asks;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public Orderbook(Timeslot timeslot, Double clearingPrice, Instant dateExecuted) {
        Timeslot timeslot2 = timeslot;
        Double d = clearingPrice;
        Instant instant = dateExecuted;
        Object[] objectArray = new Object[]{timeslot2, d, instant};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        this.id = IdGenerator.createId();
        this.bids = new TreeSet<OrderbookOrder>();
        this.asks = new TreeSet<OrderbookOrder>();
        this.timeslot = timeslot;
        this.clearingPrice = clearingPrice;
        this.dateExecuted = dateExecuted;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public long getId() {
        return this.id;
    }

    public Double getClearingPrice() {
        return this.clearingPrice;
    }

    public Instant getDateExecuted() {
        return this.dateExecuted;
    }

    public Timeslot getTimeslot() {
        return this.timeslot;
    }

    public SortedSet<OrderbookOrder> getBids() {
        return this.bids;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Orderbook addBid(OrderbookOrder orderbookOrder) {
        void bid;
        OrderbookOrder orderbookOrder2 = orderbookOrder;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)orderbookOrder2);
        this.bids.add((OrderbookOrder)bid);
        Orderbook orderbook = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return orderbook;
    }

    public SortedSet<OrderbookOrder> getAsks() {
        return this.asks;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    public Orderbook addAsk(OrderbookOrder orderbookOrder) {
        void ask;
        OrderbookOrder orderbookOrder2 = orderbookOrder;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)orderbookOrder2);
        this.asks.add((OrderbookOrder)ask);
        Orderbook orderbook = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return orderbook;
    }

    static {
        Factory factory = new Factory("Orderbook.java", Class.forName("org.powertac.common.Orderbook"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.Orderbook", "org.powertac.common.Timeslot:java.lang.Double:org.joda.time.Instant:", "timeslot:clearingPrice:dateExecuted:", ""), 73);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addBid", "org.powertac.common.Orderbook", "org.powertac.common.OrderbookOrder:", "bid:", "", "org.powertac.common.Orderbook"), 126);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addAsk", "org.powertac.common.Orderbook", "org.powertac.common.OrderbookOrder:", "ask:", "", "org.powertac.common.Orderbook"), 143);
    }
}

