/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.state;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.powertac.common.state.Domain;

@Aspect
public class StateLogging {
    private static Logger log = Logger.getLogger(StateLogging.class);
    private Logger stateLog = Logger.getLogger((String)"State");
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ StateLogging ajc$perSingletonInstance;

    static {
        try {
            StateLogging.ajc$perSingletonInstance = new StateLogging();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="execution (@StateChange * * (..))")
    public /* synthetic */ void setState() {
    }

    @Pointcut(value="execution ((@Domain *).new (..))")
    public /* synthetic */ void domainConstructor() {
    }

    @Pointcut(value="execution (Object XStreamStateLoggable.readResolve())")
    public /* synthetic */ void readResolveMethod() {
    }

    @Pointcut(value="domainConstructor() || readResolveMethod()")
    public /* synthetic */ void newState() {
    }

    @AfterReturning(value="setState()")
    public void setstate(JoinPoint jp) {
        Object thing = jp.getTarget();
        Object[] args = jp.getArgs();
        Signature sig = jp.getSignature();
        Long id = this.findId(thing);
        this.writeLog(thing.getClass().getName(), id, sig.getName(), args);
    }

    @AfterReturning(value="newState()")
    public void newstate(JoinPoint jp) {
        Object thing = jp.getTarget();
        Object[] args = jp.getArgs();
        Signature sig = jp.getSignature();
        Long id = this.findId(thing);
        if ("readResolve".equals(sig.getName())) {
            args = this.collectProperties(thing);
        }
        this.writeLog(thing.getClass().getName(), id, "new", args);
    }

    private Object[] collectProperties(Object thing) {
        ArrayList<Object> properties = new ArrayList<Object>();
        try {
            Domain domain = thing.getClass().getAnnotation(Domain.class);
            if (domain instanceof Domain) {
                String[] fields;
                String[] stringArray = fields = domain.fields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    String field = stringArray[n2];
                    Object obj = PropertyUtils.getSimpleProperty((Object)thing, (String)field);
                    properties.add(obj);
                    ++n2;
                }
            }
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Failed to introspec " + thing.getClass().getSimpleName()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)("Failed to introspec " + thing.getClass().getSimpleName()), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)("Failed to introspec " + thing.getClass().getSimpleName()), (Throwable)e);
        }
        return properties.toArray();
    }

    private void writeLog(String className, Long id, String methodName, Object[] args) {
        StringBuffer buf = new StringBuffer();
        buf.append(className).append("::");
        buf.append(id == null ? "null" : id.toString()).append("::");
        buf.append(methodName);
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            buf.append("::");
            this.writeArg(buf, arg);
            ++n2;
        }
        this.stateLog.info((Object)buf.toString());
    }

    private void writeArg(StringBuffer buf, Object arg) {
        Long argId = this.findId(arg);
        if (argId != null) {
            buf.append(argId.toString());
        } else if (arg == null) {
            buf.append("null");
        } else if (arg instanceof Collection) {
            buf.append("(");
            String delimiter = "";
            for (Object item : (Collection)arg) {
                buf.append(delimiter);
                this.writeArg(buf, item);
                delimiter = ",";
            }
            buf.append(")");
        } else if (arg.getClass().isArray()) {
            buf.append("[");
            int length = Array.getLength(arg);
            int index = 0;
            while (index < length) {
                this.writeArg(buf, Array.get(arg, index));
                if (index < length - 1) {
                    buf.append(",");
                }
                ++index;
            }
            buf.append("]");
        } else {
            buf.append(arg.toString());
        }
    }

    Long findId(Object thing) {
        Long id = null;
        try {
            Method getId = thing.getClass().getMethod("getId", new Class[0]);
            id = (Long)getId.invoke(thing, new Object[0]);
        }
        catch (Exception exception) {}
        return id;
    }

    public static StateLogging aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.powertac.common.state.StateLogging", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

