/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.msg;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.powertac.common.Broker;
import org.powertac.common.HourlyCharge;
import org.powertac.common.Rate;
import org.powertac.common.msg.TariffUpdate;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateLogging;

@Domain(fields={"broker", "tariffId", "hourlyChargeId", "rateId"})
@XStreamAlias(value="tariff-vru")
public class VariableRateUpdate
extends TariffUpdate {
    private HourlyCharge payload;
    @XStreamAsAttribute
    private long rateId;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public VariableRateUpdate(Broker broker, Rate rate, HourlyCharge hourlyCharge) {
        super(broker, rate.getTariffId());
        Broker broker2 = broker;
        Rate rate2 = rate;
        HourlyCharge hourlyCharge2 = hourlyCharge;
        Object[] objectArray = new Object[]{broker2, rate2, hourlyCharge2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        this.rateId = rate.getId();
        this.payload = hourlyCharge;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public HourlyCharge getHourlyCharge() {
        return this.payload;
    }

    public long getHourlyChargeId() {
        return this.payload.getId();
    }

    public long getRateId() {
        return this.rateId;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    public boolean isValid(Rate rate) {
        if (rate.getId() != this.rateId) {
            return false;
        }
        if (rate.isFixed()) {
            return false;
        }
        double value = this.payload.getValue();
        double sgn = Math.signum(rate.getMinValue() + rate.getMaxValue());
        return !(sgn * value < sgn * rate.getMinValue()) && !(sgn * value > sgn * rate.getMaxValue());
    }

    static {
        Factory factory = new Factory("VariableRateUpdate.java", Class.forName("org.powertac.common.msg.VariableRateUpdate"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.msg.VariableRateUpdate", "org.powertac.common.Broker:org.powertac.common.Rate:org.powertac.common.HourlyCharge:", "broker:rate:hourlyCharge:", ""), 44);
    }
}

