/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.powertac.common.Competition;
import org.powertac.common.TimeService;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.DomainRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TimeslotRepo
implements DomainRepo {
    private static Logger log = Logger.getLogger((String)TimeslotRepo.class.getName());
    private int timeslotIndex = 0;
    private Timeslot first;
    private Timeslot last;
    private Timeslot firstEnabled;
    private Timeslot current;
    private ArrayList<Timeslot> indexedTimeslots = new ArrayList();
    @Autowired
    private TimeService timeService;

    public Timeslot makeTimeslot(Instant startTime) {
        long duration = Competition.currentCompetition().getTimeslotDuration();
        log.debug((Object)("makeTimeslot" + startTime.toString()));
        Instant lastStart = startTime.minus(duration);
        if (this.last != null && !this.last.getStartInstant().isEqual((ReadableInstant)lastStart)) {
            log.error((Object)("Timeslot " + (this.timeslotIndex + 1) + ": start:" + startTime.toString() + " != previous.end:" + lastStart.plus(duration)));
            return null;
        }
        Timeslot result = new Timeslot(this.timeslotIndex, startTime, this.last);
        if (result.getSerialNumber() == -1) {
            return null;
        }
        if (this.first == null) {
            this.first = result;
        }
        this.last = result;
        this.indexedTimeslots.add(this.timeslotIndex, result);
        ++this.timeslotIndex;
        return result;
    }

    public Timeslot currentTimeslot() {
        if (this.first == null) {
            return null;
        }
        Instant time = this.timeService.getCurrentTime();
        if (time == null) {
            return null;
        }
        if (this.current != null && this.current.getStartInstant().isEqual((ReadableInstant)time)) {
            return this.current;
        }
        this.current = this.findByInstant(time);
        return this.current;
    }

    public int currentSerialNumber() {
        return this.currentTimeslot().getSerialNumber();
    }

    public Timeslot findBySerialNumber(int serialNumber) {
        log.debug((Object)("find sn " + serialNumber));
        int index = serialNumber;
        if (index >= this.indexedTimeslots.size()) {
            return null;
        }
        return this.indexedTimeslots.get(index);
    }

    public Timeslot findOrCreateBySerialNumber(int serialNumber) {
        log.debug((Object)("find or create sn " + serialNumber));
        Timeslot result = this.findBySerialNumber(serialNumber);
        if (result != null) {
            return result;
        }
        if (serialNumber < 0) {
            log.error((Object)("FindOrCreate: serial number " + serialNumber + " < 0"));
            return null;
        }
        if (serialNumber < this.count()) {
            log.error((Object)("FindOrCreate: serial number " + serialNumber + " < count " + this.count()));
            return null;
        }
        if (this.last == null) {
            this.first = new Timeslot(0, Competition.currentCompetition().getSimulationBaseTime(), null);
            this.indexedTimeslots.add(0, this.first);
            this.last = this.first;
        }
        int sn = this.last.getSerialNumber() + 1;
        while (sn <= serialNumber) {
            this.last = new Timeslot(sn, this.last.getEndInstant(), this.last);
            this.indexedTimeslots.add(sn, this.last);
            ++sn;
        }
        return this.last;
    }

    public void createInitialTimeslots() {
        if (this.first == null) {
            this.makeTimeslot(Competition.currentCompetition().getSimulationBaseTime());
        }
        this.findOrCreateBySerialNumber(this.getTimeslotIndex(this.timeService.getCurrentTime()));
    }

    public Timeslot findByInstant(Instant time) {
        log.debug((Object)("find " + time.toString()));
        int index = this.getTimeslotIndex(time);
        return this.findBySerialNumber(index);
    }

    public int getTimeslotIndex(Instant time) {
        long offset = time.getMillis() - this.first.getStartInstant().getMillis();
        long duration = Competition.currentCompetition().getTimeslotDuration();
        offset -= offset % duration;
        int index = (int)(offset / duration);
        return index;
    }

    public List<Timeslot> enabledTimeslots() {
        if (this.first == null) {
            return null;
        }
        if (this.firstEnabled == null) {
            this.firstEnabled = this.first;
        }
        while (this.firstEnabled != null && !this.firstEnabled.isEnabled()) {
            this.firstEnabled = this.firstEnabled.getNext();
        }
        if (this.firstEnabled == null) {
            log.error((Object)"ran out of timeslots looking for first enabled");
            return null;
        }
        ArrayList<Timeslot> result = new ArrayList<Timeslot>(30);
        Timeslot ts = this.firstEnabled;
        while (ts != null && ts.isEnabled()) {
            result.add(ts);
            ts = ts.getNext();
        }
        return result;
    }

    public int count() {
        return this.indexedTimeslots.size();
    }

    @Override
    public void recycle() {
        log.debug((Object)"recycle");
        this.timeslotIndex = 0;
        this.first = null;
        this.last = null;
        this.firstEnabled = null;
        this.current = null;
        this.indexedTimeslots.clear();
    }
}

