/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.Instant;
import org.powertac.common.IdGenerator;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.ChainedConstructor;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateLogging;

@Domain
@XStreamAlias(value="trade")
public class ClearedTrade {
    @XStreamAsAttribute
    private long id;
    @XStreamAsAttribute
    private int timeslot;
    @XStreamAsAttribute
    private double executionPrice;
    @XStreamAsAttribute
    private double executionMWh;
    @XStreamAsAttribute
    private Instant dateExecuted;
    private static TimeslotRepo timeslotRepo;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public ClearedTrade(int timeslot, double executionMWh, double executionPrice, Instant dateExecuted) {
        int n = timeslot;
        double d = executionMWh;
        double d2 = executionPrice;
        Instant instant = dateExecuted;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), Conversions.doubleObject((double)d), Conversions.doubleObject((double)d2), instant};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        this.id = IdGenerator.createId();
        this.timeslot = timeslot;
        this.executionPrice = executionPrice;
        this.executionMWh = executionMWh;
        this.dateExecuted = dateExecuted;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    @ChainedConstructor
    public ClearedTrade(Timeslot timeslot, double executionMWh, double executionPrice, Instant dateExecuted) {
        this(timeslot.getSerialNumber(), executionMWh, executionPrice, dateExecuted);
    }

    public long getId() {
        return this.id;
    }

    public int getTimeslotIndex() {
        return this.timeslot;
    }

    public Timeslot getTimeslot() {
        return ClearedTrade.getTimeslotRepo().findBySerialNumber(this.timeslot);
    }

    public double getExecutionPrice() {
        return this.executionPrice;
    }

    public double getExecutionMWh() {
        return this.executionMWh;
    }

    public Instant getDateExecuted() {
        return this.dateExecuted;
    }

    private static TimeslotRepo getTimeslotRepo() {
        if (timeslotRepo == null) {
            timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean("timeslotRepo");
        }
        return timeslotRepo;
    }

    public String toString() {
        return "ClearedTrade " + this.executionMWh + "@" + this.executionPrice;
    }

    static {
        Factory factory = new Factory("ClearedTrade.java", Class.forName("org.powertac.common.ClearedTrade"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.ClearedTrade", "int:double:double:org.joda.time.Instant:", "timeslot:executionMWh:executionPrice:dateExecuted:", ""), 68);
    }
}

