/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.msg;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.powertac.common.TariffSpecification;
import org.powertac.common.msg.ControlEvent;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateLogging;

@Domain(fields={"tariffId", "curtailmentRatio", "timeslotIndex"})
@XStreamAlias(value="economic-control")
public class EconomicControlEvent
extends ControlEvent {
    private static Logger log;
    @XStreamAsAttribute
    private double curtailmentRatio;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        Factory factory = new Factory("EconomicControlEvent.java", Class.forName("org.powertac.common.msg.EconomicControlEvent"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.msg.EconomicControlEvent", "org.powertac.common.TariffSpecification:double:int:", "tariff:curtailmentRatio:timeslotIndex:", ""), 62);
        ajc$tjp_1 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("4", "org.powertac.common.msg.EconomicControlEvent", "", "", ""), 88);
        log = Logger.getLogger((String)EconomicControlEvent.class.getName());
    }

    public EconomicControlEvent(TariffSpecification tariff, double curtailmentRatio, int timeslotIndex) {
        super(tariff.getBroker(), tariff, timeslotIndex);
        TariffSpecification tariffSpecification = tariff;
        double d = curtailmentRatio;
        int n = timeslotIndex;
        Object[] objectArray = new Object[]{tariffSpecification, Conversions.doubleObject((double)d), Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        this.curtailmentRatio = 0.0;
        if (tariff.hasRegulationRate()) {
            if (-1.0 > curtailmentRatio || 2.0 < curtailmentRatio) {
                log.error((Object)("Illegal curtailmentRatio: " + curtailmentRatio));
                curtailmentRatio = 0.0;
            }
        } else if (0.0 > curtailmentRatio || 1.0 < curtailmentRatio) {
            log.error((Object)("Illegal curtailmentRatio: " + curtailmentRatio));
            curtailmentRatio = 0.0;
        }
        this.curtailmentRatio = curtailmentRatio;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public double getCurtailmentRatio() {
        return this.curtailmentRatio;
    }

    protected EconomicControlEvent() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        this.curtailmentRatio = 0.0;
        StateLogging.aspectOf().newstate(joinPoint);
    }
}

