/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.powertac.common.Broker;
import org.powertac.common.BrokerTransaction;
import org.powertac.common.state.Domain;

@Domain(fields={"postedTimeslot", "peakTimeslot", "threshold", "KWh", "charge"})
@XStreamAlias(value="capacity-tx")
public class CapacityTransaction
extends BrokerTransaction {
    @XStreamAsAttribute
    private int peakTimeslot = 0;
    @XStreamAsAttribute
    private double threshold = 0.0;
    @XStreamAsAttribute
    private double kWh = 0.0;
    @XStreamAsAttribute
    private double charge = 0.0;

    public CapacityTransaction(Broker broker, int when, int peakTimeslot, double threshold, double kwh, double charge) {
        super(when, broker);
        this.peakTimeslot = peakTimeslot;
        this.threshold = threshold;
        this.kWh = kwh;
        this.charge = charge;
    }

    public int getPeakTimeslot() {
        return this.peakTimeslot;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public double getKWh() {
        return this.kWh;
    }

    public double getCharge() {
        return this.charge;
    }

    public String toString() {
        return String.format("Capacity tx %d-%s-(%d,%.2f,%.2f)-%.2f", this.postedTimeslot, this.broker.getUsername(), this.peakTimeslot, this.threshold, this.kWh, this.charge);
    }
}

