/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.powertac.common.IdGenerator;
import org.powertac.common.RateCore;
import org.powertac.common.TariffSpecification;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;

@Domain(fields={"tariffId", "response", "upRegulationPayment", "downRegulationPayment"})
@XStreamAlias(value="regulation-rate")
public class RegulationRate
extends RateCore {
    @XStreamAsAttribute
    private ResponseTime response = ResponseTime.MINUTES;
    @XStreamAsAttribute
    private double upRegulationPayment = 0.0;
    @XStreamAsAttribute
    private double downRegulationPayment = 0.0;

    @StateChange
    public RegulationRate withResponse(ResponseTime time) {
        this.response = time;
        return this;
    }

    public ResponseTime getResponse() {
        return this.response;
    }

    @StateChange
    public RegulationRate withUpRegulationPayment(double payment) {
        this.upRegulationPayment = payment;
        return this;
    }

    public double getUpRegulationPayment() {
        return this.upRegulationPayment;
    }

    @StateChange
    public RegulationRate withDownRegulationPayment(double payment) {
        this.downRegulationPayment = payment;
        return this;
    }

    public double getDownRegulationPayment() {
        return this.downRegulationPayment;
    }

    public boolean isValid(TariffSpecification spec) {
        return true;
    }

    public String toString() {
        String result = "RegulationRate." + IdGenerator.getString(this.getId()) + ":";
        return result;
    }

    public static enum ResponseTime {
        SECONDS,
        MINUTES;

    }
}

