/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.List;
import org.powertac.common.IdGenerator;
import org.powertac.common.Timeslot;
import org.powertac.common.WeatherForecastPrediction;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.ChainedConstructor;
import org.powertac.common.state.Domain;

@Domain
@XStreamAlias(value="weather-forecast")
public class WeatherForecast {
    @XStreamAsAttribute
    private long id = IdGenerator.createId();
    @XStreamAsAttribute
    private int currentTimeslot;
    @XStreamImplicit(itemFieldName="prediction")
    private List<WeatherForecastPrediction> predictions;
    private static TimeslotRepo timeslotRepo;

    public WeatherForecast(int timeslot, List<WeatherForecastPrediction> predictions) {
        this.predictions = predictions;
        this.currentTimeslot = timeslot;
    }

    @Deprecated
    @ChainedConstructor
    public WeatherForecast(Timeslot timeslot, List<WeatherForecastPrediction> predictions) {
        this(timeslot.getSerialNumber(), predictions);
    }

    public List<WeatherForecastPrediction> getPredictions() {
        return this.predictions;
    }

    public long getId() {
        return this.id;
    }

    public int getTimeslotIndex() {
        return this.currentTimeslot;
    }

    @Deprecated
    public Timeslot getCurrentTimeslot() {
        return WeatherForecast.getTimeslotRepo().findBySerialNumber(this.currentTimeslot);
    }

    @Deprecated
    public Timeslot getTimeslot() {
        return this.getCurrentTimeslot();
    }

    private static TimeslotRepo getTimeslotRepo() {
        if (null == timeslotRepo) {
            timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean("timeslotRepo");
        }
        return timeslotRepo;
    }
}

