/*
 * Copyright 2011-2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an
 * "AS IS" BASIS,  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.powertac.common;

import org.powertac.common.state.Domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

/**
 * Represents interest charges and payments for brokers. Generated by
 * AccountingService once/day.
 * @author John Collins
 */
@Domain(fields = {"postedTimeslot", "amount"})
@XStreamAlias("bank-tx")
public class BankTransaction extends BrokerTransaction
{  
  /** The amount of this transaction */
  @XStreamAsAttribute
  private double amount = 0.0;

  /**
   * Constructs a new BankTransaction instance, giving it a new id.
   */
  public BankTransaction (Broker broker, double amount, int time)
  {
    super(time, broker);
    this.amount = amount;
  }

  public double getAmount ()
  {
    return amount;
  }
}
